/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ChildTestIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;

public class OneStepIterator
extends ChildTestIterator {
    protected int m_axis = -1;
    protected DTMAxisIterator m_iterator;

    OneStepIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        super(compiler, opPos, analysis);
        int firstStepPos = OpMap.getFirstChildPos(opPos);
        this.m_axis = WalkerFactory.getAxisFromStep(compiler, firstStepPos);
    }

    public OneStepIterator(DTMAxisIterator iterator, int axis) throws TransformerException {
        super((DTMAxisTraverser)null);
        this.m_iterator = iterator;
        this.m_axis = axis;
        int whatToShow = -1;
        this.initNodeTest(whatToShow);
    }

    public void setRoot(int context, Object environment) {
        super.setRoot(context, environment);
        if (this.m_axis > -1) {
            this.m_iterator = this.m_cdtm.getAxisIterator(this.m_axis);
        }
        this.m_iterator.setStartNode(this.m_context);
    }

    protected int getNextNode() {
        this.m_lastFetched = this.m_iterator.next();
        return this.m_lastFetched;
    }

    public Object clone() throws CloneNotSupportedException {
        OneStepIterator clone = (OneStepIterator)super.clone();
        if (this.m_iterator != null) {
            clone.m_iterator = this.m_iterator.cloneIterator();
        }
        return clone;
    }

    public boolean isReverseAxes() {
        return this.m_iterator.isReverse();
    }

    protected int getProximityPosition(int predicateIndex) {
        if (!this.isReverseAxes()) {
            return super.getProximityPosition(predicateIndex);
        }
        if (predicateIndex < 0) {
            return -1;
        }
        if (this.m_proximityPositions[predicateIndex] <= 0) {
            XPathContext xctxt = this.getXPathContext();
            try {
                try {
                    int next;
                    OneStepIterator clone = (OneStepIterator)this.clone();
                    int root = this.getRoot();
                    xctxt.pushCurrentNode(root);
                    clone.setRoot(root, xctxt);
                    clone.m_predCount = predicateIndex;
                    int count = 1;
                    while (-1 != (next = clone.nextNode())) {
                        ++count;
                    }
                    int n2 = predicateIndex;
                    this.m_proximityPositions[n2] = this.m_proximityPositions[n2] + count;
                }
                catch (CloneNotSupportedException cnse) {
                    Object var8_9 = null;
                    xctxt.popCurrentNode();
                }
                Object var8_8 = null;
                xctxt.popCurrentNode();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                xctxt.popCurrentNode();
                throw throwable;
            }
        }
        return this.m_proximityPositions[predicateIndex];
    }

    protected void countProximityPosition(int i2) {
        if (!this.isReverseAxes()) {
            super.countProximityPosition(i2);
        } else if (i2 < this.m_proximityPositions.length) {
            int n2 = i2;
            this.m_proximityPositions[n2] = this.m_proximityPositions[n2] - 1;
        }
    }

    public int findLastPos(XPathContext xctxt) {
        if (!this.isReverseAxes()) {
            return super.getLastPos(xctxt);
        }
        int count = 0;
        try {
            try {
                int next;
                OneStepIterator clone = (OneStepIterator)this.clone();
                int root = this.getRoot();
                xctxt.pushCurrentNode(root);
                clone.setRoot(root, xctxt);
                int predCount = clone.getPredicateCount();
                if (predCount > 0 && this == this.m_execContext.getSubContextList()) {
                    clone.m_predCount = predCount - 1;
                }
                while (-1 != (next = clone.nextNode())) {
                    ++count;
                }
            }
            catch (CloneNotSupportedException cnse) {
                Object var8_9 = null;
                xctxt.popCurrentNode();
            }
            Object var8_8 = null;
            xctxt.popCurrentNode();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            xctxt.popCurrentNode();
            throw throwable;
        }
        return count;
    }

    public void reset() {
        super.reset();
        if (null != this.m_iterator) {
            this.m_iterator.reset();
        }
    }

    public int getAxis() {
        return this.m_axis;
    }
}

