/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.operations;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class Variable
extends Expression {
    private boolean m_fixUpWasCalled = false;
    protected QName m_qname;
    protected int m_index;
    protected boolean m_isGlobal = false;

    public void fixupVariables(Vector vars, int globalsSize) {
        this.m_fixUpWasCalled = true;
        int sz = vars.size();
        int i2 = vars.size() - 1;
        while (i2 >= 0) {
            QName qn = (QName)vars.elementAt(i2);
            if (qn.equals(this.m_qname)) {
                if (i2 < globalsSize) {
                    this.m_isGlobal = true;
                    this.m_index = i2;
                } else {
                    this.m_index = i2 - globalsSize;
                }
                return;
            }
            --i2;
        }
        String msg = XSLMessages.createXPATHMessage(81, new Object[]{this.m_qname.toString()});
        TransformerException te = new TransformerException(msg, this.m_slocator);
        throw new WrappedRuntimeException(te);
    }

    public void setQName(QName qname) {
        this.m_qname = qname;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        if (this.m_fixUpWasCalled) {
            XObject result = this.m_isGlobal ? xctxt.getVarStack().getGlobalVariable(xctxt, this.m_index) : xctxt.getVarStack().getLocalVariable(xctxt, this.m_index);
            if (null == result) {
                this.warn(xctxt, 11, new Object[]{this.m_qname.getLocalPart()});
                result = new XNodeSet(xctxt.getDTMManager());
            }
            return result;
        }
        Variable variable = this;
        synchronized (variable) {
            PrefixResolver prefixResolver = xctxt.getNamespaceContext();
            if (prefixResolver instanceof ElemTemplateElement) {
                ElemVariable vvar;
                ElemTemplateElement prev = (ElemTemplateElement)prefixResolver;
                if (!(prev instanceof Stylesheet)) {
                    while (!(prev.getParentNode() instanceof Stylesheet)) {
                        ElemTemplateElement savedprev = prev;
                        while (null != (prev = prev.getPreviousSiblingElem())) {
                            if (!(prev instanceof ElemVariable) || !(vvar = (ElemVariable)prev).getName().equals(this.m_qname)) continue;
                            this.m_index = vvar.getIndex();
                            this.m_isGlobal = false;
                            this.m_fixUpWasCalled = true;
                            XObject xObject = this.execute(xctxt);
                            return xObject;
                        }
                        prev = savedprev.getParentElem();
                    }
                }
                if (null != (vvar = prev.getStylesheetRoot().getVariableOrParamComposed(this.m_qname))) {
                    this.m_index = vvar.getIndex();
                    this.m_isGlobal = true;
                    this.m_fixUpWasCalled = true;
                    XObject xObject = this.execute(xctxt);
                    return xObject;
                }
            }
        }
        throw new TransformerException(XSLMessages.createXPATHMessage(74, new Object[]{this.m_qname.toString()}));
    }

    public boolean isStableNumber() {
        return true;
    }
}

