/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;

public class StepPattern
extends NodeTest
implements SubContextList {
    protected int m_axis;
    String m_targetString;
    StepPattern m_relativePathPattern;
    Expression[] m_predicates;
    private static final boolean DEBUG_MATCHES = false;

    public StepPattern(int whatToShow, String namespace, String name, int axis, int axisForPredicate) {
        super(whatToShow, namespace, name);
        this.m_axis = axis;
    }

    public StepPattern(int whatToShow, int axis, int axisForPredicate) {
        super(whatToShow);
        this.m_axis = axis;
    }

    public void calcTargetString() {
        int whatToShow = this.getWhatToShow();
        switch (whatToShow) {
            case 128: {
                this.m_targetString = "#comment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                this.m_targetString = "#text";
                break;
            }
            case -1: {
                this.m_targetString = "*";
                break;
            }
            case 256: 
            case 1280: {
                this.m_targetString = "/";
                break;
            }
            case 1: {
                if ("*" == this.m_name) {
                    this.m_targetString = "*";
                    break;
                }
                this.m_targetString = this.m_name;
                break;
            }
            default: {
                this.m_targetString = "*";
            }
        }
    }

    public String getTargetString() {
        return this.m_targetString;
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        super.fixupVariables(vars, globalsSize);
        if (null != this.m_predicates) {
            int i2 = 0;
            while (i2 < this.m_predicates.length) {
                this.m_predicates[i2].fixupVariables(vars, globalsSize);
                ++i2;
            }
        }
        if (null != this.m_relativePathPattern) {
            this.m_relativePathPattern.fixupVariables(vars, globalsSize);
        }
    }

    public void setRelativePathPattern(StepPattern expr) {
        this.m_relativePathPattern = expr;
        this.calcScore();
    }

    public StepPattern getRelativePathPattern() {
        return this.m_relativePathPattern;
    }

    public Expression[] getPredicates() {
        return this.m_predicates;
    }

    public boolean canTraverseOutsideSubtree() {
        int n2 = this.getPredicateCount();
        int i2 = 0;
        while (i2 < n2) {
            if (this.getPredicate(i2).canTraverseOutsideSubtree()) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public Expression getPredicate(int i2) {
        return this.m_predicates[i2];
    }

    public final int getPredicateCount() {
        return null == this.m_predicates ? 0 : this.m_predicates.length;
    }

    public void setPredicates(Expression[] predicates) {
        this.m_predicates = predicates;
        this.calcScore();
    }

    public void calcScore() {
        if (this.getPredicateCount() > 0 || null != this.m_relativePathPattern) {
            this.m_score = NodeTest.SCORE_OTHER;
        } else {
            super.calcScore();
        }
        if (null == this.m_targetString) {
            this.calcTargetString();
        }
    }

    public XObject execute(XPathContext xctxt, int currentNode) throws TransformerException {
        DTM dtm = xctxt.getDTM(currentNode);
        if (dtm != null) {
            int expType = dtm.getExpandedTypeID(currentNode);
            return this.execute(xctxt, currentNode, dtm, expType);
        }
        return NodeTest.SCORE_NONE;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt, xctxt.getCurrentNode());
    }

    public XObject execute(XPathContext xctxt, int currentNode, DTM dtm, int expType) throws TransformerException {
        if (this.m_whatToShow == 65536) {
            if (null != this.m_relativePathPattern) {
                return this.m_relativePathPattern.execute(xctxt);
            }
            return NodeTest.SCORE_NONE;
        }
        XObject score = super.execute(xctxt, currentNode, dtm, expType);
        if (score == NodeTest.SCORE_NONE) {
            return NodeTest.SCORE_NONE;
        }
        if (this.getPredicateCount() != 0 && !this.executePredicates(xctxt, dtm, currentNode)) {
            return NodeTest.SCORE_NONE;
        }
        if (null != this.m_relativePathPattern) {
            return this.m_relativePathPattern.executeRelativePathPattern(xctxt, dtm, currentNode);
        }
        return score;
    }

    private final boolean checkProximityPosition(XPathContext xctxt, int predPos, DTM dtm, int context, int pos) {
        try {
            DTMAxisTraverser traverser = dtm.getAxisTraverser(12);
            int child = traverser.first(context);
            while (-1 != child) {
                Object var18_15;
                try {
                    xctxt.pushCurrentNode(child);
                    if (NodeTest.SCORE_NONE != super.execute(xctxt, child)) {
                        Object var16_14;
                        boolean pass = true;
                        try {
                            xctxt.pushSubContextList(this);
                            int i2 = 0;
                            while (i2 < predPos) {
                                Object var14_13;
                                xctxt.pushPredicatePos(i2);
                                try {
                                    Object var12_12;
                                    XObject pred;
                                    block16: {
                                        pred = this.m_predicates[i2].execute(xctxt);
                                        try {
                                            if (2 == pred.getType()) {
                                                throw new Error("Why: Should never have been called");
                                            }
                                            if (pred.boolWithSideEffects()) break block16;
                                            pass = false;
                                            var12_12 = null;
                                            pred.detach();
                                        }
                                        catch (Throwable throwable) {
                                            var12_12 = null;
                                            pred.detach();
                                            throw throwable;
                                        }
                                        var14_13 = null;
                                        xctxt.popPredicatePos();
                                        {
                                            break;
                                        }
                                    }
                                    var12_12 = null;
                                    pred.detach();
                                    {
                                    }
                                }
                                catch (Throwable throwable) {
                                    var14_13 = null;
                                    xctxt.popPredicatePos();
                                    throw throwable;
                                }
                                var14_13 = null;
                                xctxt.popPredicatePos();
                                ++i2;
                            }
                            var16_14 = null;
                            xctxt.popSubContextList();
                        }
                        catch (Throwable throwable) {
                            var16_14 = null;
                            xctxt.popSubContextList();
                            throw throwable;
                        }
                        if (pass) {
                            --pos;
                        }
                        if (pos < 1) {
                            boolean bl = false;
                            var18_15 = null;
                            xctxt.popCurrentNode();
                            return bl;
                        }
                    }
                    var18_15 = null;
                    xctxt.popCurrentNode();
                }
                catch (Throwable throwable) {
                    var18_15 = null;
                    xctxt.popCurrentNode();
                    throw throwable;
                }
                child = traverser.next(context, child);
            }
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
        return pos == 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getProximityPosition(XPathContext xctxt, int predPos, boolean findLast) {
        int pos = 0;
        int context = xctxt.getCurrentNode();
        DTM dtm = xctxt.getDTM(context);
        int parent = dtm.getParent(context);
        try {
            DTMAxisTraverser traverser = dtm.getAxisTraverser(3);
            int child = traverser.first(parent);
            while (true) {
                Object var20_17;
                if (-1 == child) {
                    return pos;
                }
                try {
                    xctxt.pushCurrentNode(child);
                    if (NodeTest.SCORE_NONE != super.execute(xctxt, child)) {
                        Object var18_16;
                        boolean pass = true;
                        try {
                            xctxt.pushSubContextList(this);
                            int i2 = 0;
                            while (true) {
                                Object var16_15;
                                block22: {
                                    block21: {
                                        if (i2 >= predPos) {
                                            break;
                                        }
                                        xctxt.pushPredicatePos(i2);
                                        try {
                                            Object var14_14;
                                            XObject pred;
                                            block18: {
                                                block20: {
                                                    block19: {
                                                        pred = this.m_predicates[i2].execute(xctxt);
                                                        try {
                                                            if (2 == pred.getType()) {
                                                                if (pos + 1 == (int)pred.numWithSideEffects()) break block18;
                                                                pass = false;
                                                                var14_14 = null;
                                                                pred.detach();
                                                                break block19;
                                                            }
                                                            if (pred.boolWithSideEffects()) break block18;
                                                            pass = false;
                                                            break block20;
                                                        }
                                                        catch (Throwable throwable) {
                                                            var14_14 = null;
                                                            pred.detach();
                                                            throw throwable;
                                                        }
                                                    }
                                                    var16_15 = null;
                                                    xctxt.popPredicatePos();
                                                    break;
                                                }
                                                var14_14 = null;
                                                pred.detach();
                                                break block21;
                                            }
                                            var14_14 = null;
                                            pred.detach();
                                            break block22;
                                        }
                                        catch (Throwable throwable) {
                                            var16_15 = null;
                                            xctxt.popPredicatePos();
                                            throw throwable;
                                        }
                                    }
                                    var16_15 = null;
                                    xctxt.popPredicatePos();
                                    break;
                                }
                                var16_15 = null;
                                xctxt.popPredicatePos();
                                ++i2;
                            }
                            var18_16 = null;
                            xctxt.popSubContextList();
                        }
                        catch (Throwable throwable) {
                            var18_16 = null;
                            xctxt.popSubContextList();
                            throw throwable;
                        }
                        if (pass) {
                            ++pos;
                        }
                        if (!findLast && child == context) {
                            int n2 = pos;
                            var20_17 = null;
                            xctxt.popCurrentNode();
                            return n2;
                        }
                    }
                    var20_17 = null;
                    xctxt.popCurrentNode();
                }
                catch (Throwable throwable) {
                    var20_17 = null;
                    xctxt.popCurrentNode();
                    throw throwable;
                }
                child = traverser.next(parent, child);
            }
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    public int getProximityPosition(XPathContext xctxt) {
        return this.getProximityPosition(xctxt, xctxt.getPredicatePos(), false);
    }

    public int getLastPos(XPathContext xctxt) {
        return this.getProximityPosition(xctxt, xctxt.getPredicatePos(), true);
    }

    protected final XObject executeRelativePathPattern(XPathContext xctxt, DTM dtm, int currentNode) throws TransformerException {
        XObject score = NodeTest.SCORE_NONE;
        int context = currentNode;
        DTMAxisTraverser traverser = dtm.getAxisTraverser(this.m_axis);
        int relative = traverser.first(context);
        while (-1 != relative) {
            Object var9_8;
            try {
                xctxt.pushCurrentNode(relative);
                score = this.execute(xctxt);
                if (score != NodeTest.SCORE_NONE) {
                    var9_8 = null;
                    xctxt.popCurrentNode();
                    break;
                }
                var9_8 = null;
                xctxt.popCurrentNode();
            }
            catch (Throwable throwable) {
                var9_8 = null;
                xctxt.popCurrentNode();
                throw throwable;
            }
            relative = traverser.next(context, relative);
        }
        return score;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final boolean executePredicates(XPathContext xctxt, DTM dtm, int currentNode) throws TransformerException {
        boolean result = true;
        boolean positionAlreadySeen = false;
        int n2 = this.getPredicateCount();
        try {
            xctxt.pushSubContextList(this);
            int i2 = 0;
            while (true) {
                Object var13_11;
                block16: {
                    block15: {
                        block14: {
                            if (i2 >= n2) {
                                break;
                            }
                            xctxt.pushPredicatePos(i2);
                            try {
                                Object var11_10;
                                XObject pred;
                                block11: {
                                    block13: {
                                        block12: {
                                            block10: {
                                                pred = this.m_predicates[i2].execute(xctxt);
                                                try {
                                                    if (2 == pred.getType()) {
                                                        int pos = (int)pred.num();
                                                        if (positionAlreadySeen) {
                                                            result = pos == 1;
                                                            var11_10 = null;
                                                            pred.detach();
                                                            break block10;
                                                        }
                                                        positionAlreadySeen = true;
                                                        if (this.checkProximityPosition(xctxt, i2, dtm, currentNode, pos)) break block11;
                                                        result = false;
                                                        break block12;
                                                    }
                                                    if (pred.boolWithSideEffects()) break block11;
                                                    result = false;
                                                    break block13;
                                                }
                                                catch (Throwable throwable) {
                                                    var11_10 = null;
                                                    pred.detach();
                                                    throw throwable;
                                                }
                                            }
                                            var13_11 = null;
                                            xctxt.popPredicatePos();
                                            break;
                                        }
                                        var11_10 = null;
                                        pred.detach();
                                        break block14;
                                    }
                                    var11_10 = null;
                                    pred.detach();
                                    break block15;
                                }
                                var11_10 = null;
                                pred.detach();
                                break block16;
                            }
                            catch (Throwable throwable) {
                                var13_11 = null;
                                xctxt.popPredicatePos();
                                throw throwable;
                            }
                        }
                        var13_11 = null;
                        xctxt.popPredicatePos();
                        break;
                    }
                    var13_11 = null;
                    xctxt.popPredicatePos();
                    break;
                }
                var13_11 = null;
                xctxt.popPredicatePos();
                ++i2;
            }
            Object var15_14 = null;
            xctxt.popSubContextList();
            return result;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            xctxt.popSubContextList();
            throw throwable;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        StepPattern pat = this;
        while (pat != null) {
            if (pat != this) {
                buf.append("/");
            }
            buf.append(Axis.names[pat.m_axis]);
            buf.append("::");
            if (20480 == pat.m_whatToShow) {
                buf.append("doc()");
            } else if (65536 == pat.m_whatToShow) {
                buf.append("function()");
            } else if (-1 == pat.m_whatToShow) {
                buf.append("node()");
            } else if (4 == pat.m_whatToShow) {
                buf.append("text()");
            } else if (64 == pat.m_whatToShow) {
                buf.append("processing-instruction(");
                if (null != pat.m_name) {
                    buf.append(pat.m_name);
                }
                buf.append(")");
            } else if (128 == pat.m_whatToShow) {
                buf.append("comment()");
            } else if (null != pat.m_name) {
                if (2 == pat.m_whatToShow) {
                    buf.append("@");
                }
                if (null != pat.m_namespace) {
                    buf.append("{");
                    buf.append(pat.m_namespace);
                    buf.append("}");
                }
                buf.append(pat.m_name);
            } else if (2 == pat.m_whatToShow) {
                buf.append("@");
            } else if (1280 == pat.m_whatToShow) {
                buf.append("doc-root()");
            } else {
                buf.append("?" + Integer.toHexString(pat.m_whatToShow));
            }
            if (null != pat.m_predicates) {
                int i2 = 0;
                while (i2 < pat.m_predicates.length) {
                    buf.append("[");
                    buf.append(pat.m_predicates[i2]);
                    buf.append("]");
                    ++i2;
                }
            }
            pat = pat.m_relativePathPattern;
        }
        return buf.toString();
    }

    public double getMatchScore(XPathContext xctxt, int context) throws TransformerException {
        xctxt.pushCurrentNode(context);
        xctxt.pushCurrentExpressionNode(context);
        try {
            XObject score = this.execute(xctxt);
            double d2 = score.num();
            Object var7_5 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            return d2;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            xctxt.popCurrentNode();
            xctxt.popCurrentExpressionNode();
            throw throwable;
        }
    }

    public void setAxis(int axis) {
        this.m_axis = axis;
    }

    public int getAxis() {
        return this.m_axis;
    }
}

