/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.patterns;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;

public class UnionPattern
extends Expression {
    private StepPattern[] m_patterns;

    public void fixupVariables(Vector vars, int globalsSize) {
        int i2 = 0;
        while (i2 < this.m_patterns.length) {
            this.m_patterns[i2].fixupVariables(vars, globalsSize);
            ++i2;
        }
    }

    public boolean canTraverseOutsideSubtree() {
        if (null != this.m_patterns) {
            int n2 = this.m_patterns.length;
            int i2 = 0;
            while (i2 < n2) {
                if (this.m_patterns[i2].canTraverseOutsideSubtree()) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public void setPatterns(StepPattern[] patterns) {
        this.m_patterns = patterns;
    }

    public StepPattern[] getPatterns() {
        return this.m_patterns;
    }

    public XObject execute(XPathContext xctxt) throws TransformerException {
        XObject bestScore = null;
        int n2 = this.m_patterns.length;
        int i2 = 0;
        while (i2 < n2) {
            XObject score = this.m_patterns[i2].execute(xctxt);
            if (score != NodeTest.SCORE_NONE) {
                if (null == bestScore) {
                    bestScore = score;
                } else if (score.num() > bestScore.num()) {
                    bestScore = score;
                }
            }
            ++i2;
        }
        if (null == bestScore) {
            bestScore = NodeTest.SCORE_NONE;
        }
        return bestScore;
    }
}

