/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGcircle
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint center;
    public double radius;

    public PGcircle(double x2, double y2, double r2) {
        this(new PGpoint(x2, y2), r2);
    }

    public PGcircle(PGpoint c2, double r2) {
        this();
        this.center = c2;
        this.radius = r2;
    }

    public PGcircle(String s2) throws SQLException {
        this();
        this.setValue(s2);
    }

    public PGcircle() {
        this.setType("circle");
    }

    public void setValue(String s2) throws SQLException {
        PGtokenizer t2 = new PGtokenizer(PGtokenizer.removeAngle(s2), ',');
        if (t2.getSize() != 2) {
            throw new PSQLException("postgresql.geo.circle", PSQLState.DATA_TYPE_MISMATCH, s2);
        }
        try {
            this.center = new PGpoint(t2.getToken(0));
            this.radius = Double.valueOf(t2.getToken(1));
        }
        catch (NumberFormatException e2) {
            throw new PSQLException("postgresql.geo.circle", PSQLState.DATA_TYPE_MISMATCH, (Object)e2);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGcircle) {
            PGcircle p2 = (PGcircle)obj;
            return p2.center.equals(this.center) && p2.radius == this.radius;
        }
        return false;
    }

    public Object clone() {
        return new PGcircle((PGpoint)this.center.clone(), this.radius);
    }

    public String getValue() {
        return "<" + this.center + "," + this.radius + ">";
    }
}

