/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PGline
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] point = new PGpoint[2];

    public PGline(double x1, double y1, double x2, double y2) {
        this(new PGpoint(x1, y1), new PGpoint(x2, y2));
    }

    public PGline(PGpoint p1, PGpoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public PGline(String s2) throws SQLException {
        this();
        this.setValue(s2);
    }

    public PGline() {
        this.setType("line");
    }

    public void setValue(String s2) throws SQLException {
        PGtokenizer t2 = new PGtokenizer(PGtokenizer.removeBox(s2), ',');
        if (t2.getSize() != 2) {
            throw new PSQLException("postgresql.geo.line", PSQLState.DATA_TYPE_MISMATCH, s2);
        }
        this.point[0] = new PGpoint(t2.getToken(0));
        this.point[1] = new PGpoint(t2.getToken(1));
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGline) {
            PGline p2 = (PGline)obj;
            return p2.point[0].equals(this.point[0]) && p2.point[1].equals(this.point[1]) || p2.point[0].equals(this.point[1]) && p2.point[1].equals(this.point[0]);
        }
        return false;
    }

    public Object clone() {
        return new PGline((PGpoint)this.point[0].clone(), (PGpoint)this.point[1].clone());
    }

    public String getValue() {
        return "[" + this.point[0] + "," + this.point[1] + "]";
    }
}

