/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc1;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.PGNotification;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseResultSet;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Encoding;
import org.postgresql.core.PGStream;
import org.postgresql.core.QueryExecutor;
import org.postgresql.core.StartupPacket;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.UnixCrypt;

public abstract class AbstractJdbc1Connection
implements BaseConnection {
    private PGStream pgStream;
    protected String PG_HOST;
    protected int PG_PORT;
    protected String PG_USER;
    protected String PG_DATABASE;
    protected boolean PG_STATUS;
    protected String compatible;
    protected boolean useSSL;
    protected int pid;
    protected int ckey;
    private Vector m_notifications;
    private Encoding encoding = Encoding.defaultEncoding();
    private String dbVersionNumber;
    public boolean CONNECTION_OK = true;
    public boolean CONNECTION_BAD = false;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public Driver this_driver;
    private String this_url;
    private String cursor = null;
    private int PGProtocolVersionMajor = 2;
    private int PGProtocolVersionMinor = 0;
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static Hashtable sqlTypeCache = new Hashtable();
    private static Hashtable pgTypeCache = new Hashtable();
    private static Hashtable typeOidCache = new Hashtable();
    public SQLWarning firstWarning = null;
    private int isolationLevel = 2;
    int lastMessage = 0;
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    private Hashtable objectTypes = new Hashtable();
    private static final String[][] defaultObjectTypes = new String[][]{{"box", "org.postgresql.geometric.PGbox"}, {"circle", "org.postgresql.geometric.PGcircle"}, {"line", "org.postgresql.geometric.PGline"}, {"lseg", "org.postgresql.geometric.PGlseg"}, {"path", "org.postgresql.geometric.PGpath"}, {"point", "org.postgresql.geometric.PGpoint"}, {"polygon", "org.postgresql.geometric.PGpolygon"}, {"money", "org.postgresql.util.PGmoney"}};
    protected DatabaseMetaData metadata;
    private static final String[] jdbc1Types = new String[]{"int2", "int4", "oid", "int8", "cash", "money", "numeric", "float4", "float8", "bpchar", "char", "char2", "char4", "char8", "char16", "varchar", "text", "name", "filename", "bytea", "bool", "bit", "date", "time", "abstime", "timestamp", "timestamptz"};
    private static final int[] jdbc1Typei = new int[]{5, 4, 4, -5, 8, 8, 2, 7, 8, 1, 1, 1, 1, 1, 1, 12, 12, 12, 12, -2, -7, -7, 91, 92, 93, 93, 93};

    public PGStream getPGStream() {
        return this.pgStream;
    }

    public int getPGProtocolVersionMajor() {
        return this.PGProtocolVersionMajor;
    }

    public int getPGProtocolVersionMinor() {
        return this.PGProtocolVersionMinor;
    }

    public abstract Statement createStatement() throws SQLException;

    public abstract DatabaseMetaData getMetaData() throws SQLException;

    public void openConnection(String host, int port, Properties info, String database, String url, Driver d2) throws SQLException {
        this.firstWarning = null;
        if (info.getProperty("user") == null) {
            throw new PSQLException("postgresql.con.user", PSQLState.CONNECTION_REJECTED);
        }
        this.this_driver = d2;
        this.this_url = url;
        this.PG_DATABASE = database;
        this.PG_USER = info.getProperty("user");
        String password = info.getProperty("password", "");
        this.PG_PORT = port;
        this.PG_HOST = host;
        this.PG_STATUS = this.CONNECTION_BAD;
        this.useSSL = info.getProperty("ssl") != null && Driver.sslEnabled();
        this.compatible = info.getProperty("compatible") == null ? d2.getMajorVersion() + "." + d2.getMinorVersion() : info.getProperty("compatible");
        String l_logLevelProp = info.getProperty("loglevel", "0");
        int l_logLevel = 0;
        try {
            l_logLevel = Integer.parseInt(l_logLevelProp);
            if (l_logLevel > 2 || l_logLevel < 1) {
                l_logLevel = 0;
            }
        }
        catch (Exception l_e) {
            // empty catch block
        }
        if (l_logLevel > 0) {
            Driver.setLogLevel(l_logLevel);
            this.enableDriverManagerLogging();
        }
        if (Driver.logInfo) {
            Driver.info(Driver.getVersion());
        }
        if (Driver.logDebug) {
            Driver.debug("    ssl = " + this.useSSL);
            Driver.debug("    compatible = " + this.compatible);
            Driver.debug("    loglevel = " + l_logLevel);
        }
        try {
            this.pgStream = new PGStream(host, port);
        }
        catch (ConnectException cex) {
            throw new PSQLException("postgresql.con.refused", PSQLState.CONNECTION_REJECTED);
        }
        catch (IOException e2) {
            throw new PSQLException("postgresql.con.failed", PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Object)e2);
        }
        try {
            if (this.haveMinimumCompatibleVersion("7.4")) {
                this.openConnectionV3(host, port, info, database, url, d2, password);
            } else {
                this.openConnectionV2(host, port, info, database, url, d2, password);
            }
        }
        catch (SQLException sqle) {
            try {
                this.pgStream.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw sqle;
        }
    }

    private void openConnectionV3(String p_host, int p_port, Properties p_info, String p_database, String p_url, Driver p_d, String p_password) throws SQLException {
        int beresp;
        this.PGProtocolVersionMajor = 3;
        if (Driver.logDebug) {
            Driver.debug("Using Protocol Version3");
        }
        try {
            if (this.useSSL) {
                if (Driver.logDebug) {
                    Driver.debug("Asking server if it supports ssl");
                }
                this.pgStream.SendInteger(8, 4);
                this.pgStream.SendInteger(80877103, 4);
                this.pgStream.flush();
                beresp = this.pgStream.ReceiveChar();
                if (Driver.logDebug) {
                    Driver.debug("Server response was (S=Yes,N=No): " + (char)beresp);
                }
                switch (beresp) {
                    case 69: {
                        throw new PSQLException("postgresql.con.misc", PSQLState.CONNECTION_REJECTED, this.pgStream.ReceiveString(this.encoding));
                    }
                    case 78: {
                        throw new PSQLException("postgresql.con.sslnotsupported", PSQLState.CONNECTION_FAILURE);
                    }
                    case 83: {
                        if (Driver.logDebug) {
                            Driver.debug("server does support ssl");
                        }
                        Driver.makeSSL(this.pgStream);
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.con.sslfail", PSQLState.CONNECTION_FAILURE);
                    }
                }
            }
        }
        catch (IOException e2) {
            throw new PSQLException("postgresql.con.failed", PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Object)e2);
        }
        try {
            new StartupPacket(this.PGProtocolVersionMajor, this.PGProtocolVersionMinor, this.PG_USER, p_database).writeTo(this.pgStream);
            this.pgStream.flush();
            int areq = -1;
            do {
                int beresp2 = this.pgStream.ReceiveChar();
                String salt = null;
                byte[] md5Salt = new byte[4];
                block8 : switch (beresp2) {
                    case 69: {
                        int l_elen = this.pgStream.ReceiveIntegerR(4);
                        if (l_elen > 30000) {
                            this.pgStream.close();
                            try {
                                this.pgStream = new PGStream(p_host, p_port);
                            }
                            catch (ConnectException cex) {
                                throw new PSQLException("postgresql.con.refused", PSQLState.CONNECTION_REJECTED);
                            }
                            catch (IOException e3) {
                                throw new PSQLException("postgresql.con.failed", PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Object)e3);
                            }
                            this.openConnectionV2(p_host, p_port, p_info, p_database, p_url, p_d, p_password);
                            return;
                        }
                        throw new PSQLException("postgresql.con.misc", PSQLState.CONNECTION_REJECTED, (Object)PSQLException.parseServerError(this.encoding.decode(this.pgStream.Receive(l_elen - 4))));
                    }
                    case 82: {
                        int l_msgLen = this.pgStream.ReceiveIntegerR(4);
                        areq = this.pgStream.ReceiveIntegerR(4);
                        if (areq == 4) {
                            byte[] rst = new byte[]{(byte)this.pgStream.ReceiveChar(), (byte)this.pgStream.ReceiveChar()};
                            salt = new String(rst, 0, 2);
                            if (Driver.logDebug) {
                                Driver.debug("Crypt salt=" + salt);
                            }
                        }
                        if (areq == 5) {
                            md5Salt[0] = (byte)this.pgStream.ReceiveChar();
                            md5Salt[1] = (byte)this.pgStream.ReceiveChar();
                            md5Salt[2] = (byte)this.pgStream.ReceiveChar();
                            md5Salt[3] = (byte)this.pgStream.ReceiveChar();
                            if (Driver.logDebug) {
                                String md5SaltString = "";
                                for (int i2 = 0; i2 < md5Salt.length; ++i2) {
                                    md5SaltString = md5SaltString + " " + md5Salt[i2];
                                }
                                Driver.debug("MD5 salt=" + md5SaltString);
                            }
                        }
                        switch (areq) {
                            case 0: {
                                break block8;
                            }
                            case 1: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: KRB4");
                                }
                                throw new PSQLException("postgresql.con.kerb4", PSQLState.CONNECTION_REJECTED);
                            }
                            case 2: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: KRB5");
                                }
                                throw new PSQLException("postgresql.con.kerb5", PSQLState.CONNECTION_REJECTED);
                            }
                            case 6: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: SCM");
                                }
                                throw new PSQLException("postgresql.con.scm", PSQLState.CONNECTION_REJECTED);
                            }
                            case 3: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: PASSWORD");
                                }
                                this.pgStream.SendChar(112);
                                this.pgStream.SendInteger(5 + p_password.length(), 4);
                                this.pgStream.Send(p_password.getBytes());
                                this.pgStream.SendChar(0);
                                this.pgStream.flush();
                                break block8;
                            }
                            case 4: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: CRYPT");
                                }
                                String crypted = UnixCrypt.crypt(salt, p_password);
                                this.pgStream.SendChar(112);
                                this.pgStream.SendInteger(5 + crypted.length(), 4);
                                this.pgStream.Send(crypted.getBytes());
                                this.pgStream.SendChar(0);
                                this.pgStream.flush();
                                break block8;
                            }
                            case 5: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: MD5");
                                }
                                byte[] digest = MD5Digest.encode(this.PG_USER, p_password, md5Salt);
                                this.pgStream.SendChar(112);
                                this.pgStream.SendInteger(5 + digest.length, 4);
                                this.pgStream.Send(digest);
                                this.pgStream.SendChar(0);
                                this.pgStream.flush();
                                break block8;
                            }
                        }
                        throw new PSQLException("postgresql.con.auth", PSQLState.CONNECTION_REJECTED, new Integer(areq));
                    }
                    default: {
                        throw new PSQLException("postgresql.con.authfail", PSQLState.CONNECTION_REJECTED);
                    }
                }
            } while (areq != 0);
        }
        catch (IOException e4) {
            throw new PSQLException("postgresql.con.failed", PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Object)e4);
        }
        block34: do {
            beresp = this.pgStream.ReceiveChar();
            switch (beresp) {
                case 90: {
                    break;
                }
                case 75: {
                    int l_msgLen = this.pgStream.ReceiveIntegerR(4);
                    if (l_msgLen != 12) {
                        throw new PSQLException("postgresql.con.setup", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    this.pid = this.pgStream.ReceiveIntegerR(4);
                    this.ckey = this.pgStream.ReceiveIntegerR(4);
                    break;
                }
                case 69: {
                    int l_elen = this.pgStream.ReceiveIntegerR(4);
                    throw new PSQLException("postgresql.con.backend", PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Object)PSQLException.parseServerError(this.encoding.decode(this.pgStream.Receive(l_elen - 4))));
                }
                case 78: {
                    int l_nlen = this.pgStream.ReceiveIntegerR(4);
                    PSQLException notify = PSQLException.parseServerError(this.encoding.decode(this.pgStream.Receive(l_nlen - 4)));
                    this.addWarning(notify.getMessage());
                    break;
                }
                case 83: {
                    int l_len = this.pgStream.ReceiveIntegerR(4);
                    String l_pStatus = this.encoding.decode(this.pgStream.Receive(l_len - 4));
                    if (!Driver.logDebug) continue block34;
                    Driver.debug("ParameterStatus=" + l_pStatus);
                    break;
                }
                default: {
                    if (Driver.logDebug) {
                        Driver.debug("invalid state=" + (char)beresp);
                    }
                    throw new PSQLException("postgresql.con.setup", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
            }
        } while (beresp != 90);
        if (this.pgStream.ReceiveIntegerR(4) != 5) {
            throw new PSQLException("postgresql.con.setup", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        char l_tStatus = (char)this.pgStream.ReceiveChar();
        String encodingQuery = "case when pg_encoding_to_char(1) = 'SQL_ASCII' then 'UNKNOWN' else getdatabaseencoding() end";
        BaseResultSet resultSet = this.execSQL("set datestyle to 'ISO'; select version(), case when pg_encoding_to_char(1) = 'SQL_ASCII' then 'UNKNOWN' else getdatabaseencoding() end;");
        if (!resultSet.next()) {
            throw new PSQLException("postgresql.con.failed.bad.encoding", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        String version = resultSet.getString(1);
        this.dbVersionNumber = AbstractJdbc1Connection.extractVersionNumber(version);
        String dbEncoding = resultSet.getString(2);
        this.encoding = Encoding.getEncoding(dbEncoding, p_info.getProperty("charSet"));
        if (this.haveMinimumServerVersion("7.3")) {
            BaseResultSet acRset = this.execSQL("set client_encoding = 'UNICODE'");
            this.encoding = Encoding.getEncoding("UNICODE", null);
        }
        this.initObjectTypes();
        this.PG_STATUS = this.CONNECTION_OK;
    }

    private void openConnectionV2(String host, int port, Properties info, String database, String url, Driver d2, String password) throws SQLException {
        int beresp;
        this.PGProtocolVersionMajor = 2;
        if (Driver.logDebug) {
            Driver.debug("Using Protocol Version2");
        }
        try {
            if (this.useSSL) {
                if (Driver.logDebug) {
                    Driver.debug("Asking server if it supports ssl");
                }
                this.pgStream.SendInteger(8, 4);
                this.pgStream.SendInteger(80877103, 4);
                this.pgStream.flush();
                beresp = this.pgStream.ReceiveChar();
                if (Driver.logDebug) {
                    Driver.debug("Server response was (S=Yes,N=No): " + (char)beresp);
                }
                switch (beresp) {
                    case 69: {
                        throw new PSQLException("postgresql.con.misc", PSQLState.CONNECTION_REJECTED, this.pgStream.ReceiveString(this.encoding));
                    }
                    case 78: {
                        throw new PSQLException("postgresql.con.sslnotsupported", PSQLState.CONNECTION_FAILURE);
                    }
                    case 83: {
                        if (Driver.logDebug) {
                            Driver.debug("server does support ssl");
                        }
                        Driver.makeSSL(this.pgStream);
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.con.sslfail", PSQLState.CONNECTION_FAILURE);
                    }
                }
            }
        }
        catch (IOException e2) {
            throw new PSQLException("postgresql.con.failed", PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Object)e2);
        }
        try {
            new StartupPacket(this.PGProtocolVersionMajor, this.PGProtocolVersionMinor, this.PG_USER, database).writeTo(this.pgStream);
            this.pgStream.flush();
            int areq = -1;
            do {
                int beresp2 = this.pgStream.ReceiveChar();
                String salt = null;
                byte[] md5Salt = new byte[4];
                block7 : switch (beresp2) {
                    case 69: {
                        throw new PSQLException("postgresql.con.misc", PSQLState.CONNECTION_REJECTED, this.pgStream.ReceiveString(this.encoding));
                    }
                    case 82: {
                        areq = this.pgStream.ReceiveIntegerR(4);
                        if (areq == 4) {
                            byte[] rst = new byte[]{(byte)this.pgStream.ReceiveChar(), (byte)this.pgStream.ReceiveChar()};
                            salt = new String(rst, 0, 2);
                            if (Driver.logDebug) {
                                Driver.debug("Crypt salt=" + salt);
                            }
                        }
                        if (areq == 5) {
                            md5Salt[0] = (byte)this.pgStream.ReceiveChar();
                            md5Salt[1] = (byte)this.pgStream.ReceiveChar();
                            md5Salt[2] = (byte)this.pgStream.ReceiveChar();
                            md5Salt[3] = (byte)this.pgStream.ReceiveChar();
                            if (Driver.logDebug) {
                                String md5SaltString = "";
                                for (int i2 = 0; i2 < md5Salt.length; ++i2) {
                                    md5SaltString = md5SaltString + " " + md5Salt[i2];
                                }
                                Driver.debug("MD5 salt=" + md5SaltString);
                            }
                        }
                        switch (areq) {
                            case 0: {
                                break block7;
                            }
                            case 1: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: KRB4");
                                }
                                throw new PSQLException("postgresql.con.kerb4", PSQLState.CONNECTION_REJECTED);
                            }
                            case 2: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: KRB5");
                                }
                                throw new PSQLException("postgresql.con.kerb5", PSQLState.CONNECTION_REJECTED);
                            }
                            case 3: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: PASSWORD");
                                }
                                this.pgStream.SendInteger(5 + password.length(), 4);
                                this.pgStream.Send(password.getBytes());
                                this.pgStream.SendInteger(0, 1);
                                this.pgStream.flush();
                                break block7;
                            }
                            case 4: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: CRYPT");
                                }
                                String crypted = UnixCrypt.crypt(salt, password);
                                this.pgStream.SendInteger(5 + crypted.length(), 4);
                                this.pgStream.Send(crypted.getBytes());
                                this.pgStream.SendInteger(0, 1);
                                this.pgStream.flush();
                                break block7;
                            }
                            case 5: {
                                if (Driver.logDebug) {
                                    Driver.debug("postgresql: MD5");
                                }
                                byte[] digest = MD5Digest.encode(this.PG_USER, password, md5Salt);
                                this.pgStream.SendInteger(5 + digest.length, 4);
                                this.pgStream.Send(digest);
                                this.pgStream.SendInteger(0, 1);
                                this.pgStream.flush();
                                break block7;
                            }
                        }
                        throw new PSQLException("postgresql.con.auth", PSQLState.CONNECTION_REJECTED, new Integer(areq));
                    }
                    default: {
                        throw new PSQLException("postgresql.con.authfail", PSQLState.CONNECTION_REJECTED);
                    }
                }
            } while (areq != 0);
        }
        catch (IOException e3) {
            throw new PSQLException("postgresql.con.failed", PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Object)e3);
        }
        do {
            beresp = this.pgStream.ReceiveChar();
            switch (beresp) {
                case 75: {
                    this.pid = this.pgStream.ReceiveIntegerR(4);
                    this.ckey = this.pgStream.ReceiveIntegerR(4);
                    break;
                }
                case 69: {
                    throw new PSQLException("postgresql.con.backend", PSQLState.CONNECTION_UNABLE_TO_CONNECT, this.pgStream.ReceiveString(this.encoding));
                }
                case 78: {
                    this.addWarning(this.pgStream.ReceiveString(this.encoding));
                    break;
                }
                default: {
                    throw new PSQLException("postgresql.con.setup", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
            }
        } while (beresp == 78);
        do {
            beresp = this.pgStream.ReceiveChar();
            switch (beresp) {
                case 90: {
                    break;
                }
                case 78: {
                    this.addWarning(this.pgStream.ReceiveString(this.encoding));
                    break;
                }
                case 69: {
                    throw new PSQLException("postgresql.con.backend", PSQLState.CONNECTION_UNABLE_TO_CONNECT, this.pgStream.ReceiveString(this.encoding));
                }
                default: {
                    throw new PSQLException("postgresql.con.setup", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                }
            }
        } while (beresp == 78);
        String encodingQuery = "case when pg_encoding_to_char(1) = 'SQL_ASCII' then 'UNKNOWN' else getdatabaseencoding() end";
        BaseResultSet resultSet = this.execSQL("set datestyle to 'ISO'; select version(), case when pg_encoding_to_char(1) = 'SQL_ASCII' then 'UNKNOWN' else getdatabaseencoding() end;");
        if (!resultSet.next()) {
            throw new PSQLException("postgresql.con.failed.bad.encoding", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        String version = resultSet.getString(1);
        this.dbVersionNumber = AbstractJdbc1Connection.extractVersionNumber(version);
        String dbEncoding = resultSet.getString(2);
        this.encoding = Encoding.getEncoding(dbEncoding, info.getProperty("charSet"));
        if (this.haveMinimumServerVersion("7.4")) {
            BaseResultSet acRset = this.execSQL("set client_encoding = 'UNICODE'");
            this.encoding = Encoding.getEncoding("UNICODE", null);
        }
        if (this.haveMinimumServerVersion("7.3") && !this.haveMinimumServerVersion("7.4")) {
            BaseResultSet acRset = this.execSQL("set client_encoding = 'UNICODE'; show autocommit");
            this.encoding = Encoding.getEncoding("UNICODE", null);
            if (!acRset.next()) {
                throw new PSQLException("postgresql.con.failed.bad.autocommit", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
            }
            if (acRset.getString(1).equals("off")) {
                this.execSQL("set autocommit = on; commit;");
            }
        }
        this.initObjectTypes();
        this.PG_STATUS = this.CONNECTION_OK;
    }

    public Driver getDriver() {
        return this.this_driver;
    }

    public void addWarning(String msg) {
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(new SQLWarning(msg));
        } else {
            this.firstWarning = new SQLWarning(msg);
        }
    }

    public BaseResultSet execSQL(String s2) throws SQLException {
        Object[] nullarr = new Object[]{};
        BaseStatement stat = (BaseStatement)((Object)this.createStatement());
        return QueryExecutor.execute(new String[]{s2}, nullarr, stat);
    }

    public void setCursorName(String cursor) throws SQLException {
        this.cursor = cursor;
    }

    public String getCursorName() throws SQLException {
        return this.cursor;
    }

    public String getURL() throws SQLException {
        return this.this_url;
    }

    public String getUserName() throws SQLException {
        return this.PG_USER;
    }

    public Encoding getEncoding() throws SQLException {
        return this.encoding;
    }

    public Fastpath getFastpathAPI() throws SQLException {
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this, this.pgStream);
        }
        return this.fastpath;
    }

    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    public Object getObject(String type, String value) throws SQLException {
        try {
            Object o2 = this.objectTypes.get(type);
            if (o2 != null && o2 instanceof String) {
                PGobject obj = null;
                obj = (PGobject)Class.forName((String)o2).newInstance();
                obj.setType(type);
                obj.setValue(value);
                return obj;
            }
        }
        catch (SQLException sx) {
            sx.fillInStackTrace();
            throw sx;
        }
        catch (Exception ex) {
            throw new PSQLException("postgresql.con.creobj", PSQLState.CONNECTION_FAILURE, type, (Object)ex);
        }
        return null;
    }

    public void addDataType(String type, String name) {
        this.objectTypes.put(type, name);
    }

    private void initObjectTypes() {
        for (int i2 = 0; i2 < defaultObjectTypes.length; ++i2) {
            this.objectTypes.put(defaultObjectTypes[i2][0], defaultObjectTypes[i2][1]);
        }
    }

    public void close() throws SQLException {
        if (this.getPGProtocolVersionMajor() == 3) {
            this.closeV3();
        } else {
            this.closeV2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeV3() throws SQLException {
        if (this.pgStream != null) {
            try {
                this.pgStream.SendChar(88);
                this.pgStream.SendInteger(4, 4);
                this.pgStream.flush();
                this.pgStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.pgStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeV2() throws SQLException {
        if (this.pgStream != null) {
            try {
                this.pgStream.SendChar(88);
                this.pgStream.flush();
                this.pgStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.pgStream = null;
            }
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.autoCommit == autoCommit) {
            return;
        }
        if (autoCommit) {
            this.execSQL("end");
        } else if (this.haveMinimumServerVersion("7.1")) {
            this.execSQL("begin;" + this.getIsolationLevelSQL());
        } else {
            this.execSQL("begin");
            this.execSQL(this.getIsolationLevelSQL());
        }
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void commit() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        if (this.haveMinimumServerVersion("7.1")) {
            this.execSQL("commit;begin;" + this.getIsolationLevelSQL());
        } else {
            this.execSQL("commit");
            this.execSQL("begin");
            this.execSQL(this.getIsolationLevelSQL());
        }
    }

    public void rollback() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        if (this.haveMinimumServerVersion("7.1")) {
            this.execSQL("rollback; begin;" + this.getIsolationLevelSQL());
        } else {
            this.execSQL("rollback");
            this.execSQL("begin");
            this.execSQL(this.getIsolationLevelSQL());
        }
    }

    public int getTransactionIsolation() throws SQLException {
        String sql = "show transaction isolation level";
        String level = null;
        if (this.haveMinimumServerVersion("7.3")) {
            BaseResultSet rs = this.execSQL(sql);
            if (rs.next()) {
                level = rs.getString(1);
            }
            rs.close();
        } else {
            BaseResultSet l_rs = this.execSQL(sql);
            BaseStatement l_stat = l_rs.getPGStatement();
            SQLWarning warning = l_stat.getWarnings();
            if (warning != null) {
                level = warning.getMessage();
            }
            l_rs.close();
            l_stat.close();
        }
        if (level != null) {
            if ((level = level.toUpperCase()).indexOf("READ COMMITTED") != -1) {
                return 2;
            }
            if (level.indexOf("READ UNCOMMITTED") != -1) {
                return 1;
            }
            if (level.indexOf("REPEATABLE READ") != -1) {
                return 4;
            }
            if (level.indexOf("SERIALIZABLE") != -1) {
                return 8;
            }
        }
        return 2;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        String isolationLevelSQL;
        this.isolationLevel = level;
        if (!this.haveMinimumServerVersion("7.1")) {
            isolationLevelSQL = this.getIsolationLevelSQL();
        } else {
            isolationLevelSQL = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL ";
            switch (this.isolationLevel) {
                case 2: {
                    isolationLevelSQL = isolationLevelSQL + "READ COMMITTED";
                    break;
                }
                case 8: {
                    isolationLevelSQL = isolationLevelSQL + "SERIALIZABLE";
                    break;
                }
                default: {
                    throw new PSQLException("postgresql.con.isolevel", PSQLState.TRANSACTION_STATE_INVALID, new Integer(this.isolationLevel));
                }
            }
        }
        this.execSQL(isolationLevelSQL);
    }

    protected String getIsolationLevelSQL() throws SQLException {
        if (this.haveMinimumServerVersion("7.1")) {
            return "";
        }
        StringBuffer sb = new StringBuffer("SET TRANSACTION ISOLATION LEVEL");
        switch (this.isolationLevel) {
            case 2: {
                sb.append(" READ COMMITTED");
                break;
            }
            case 8: {
                sb.append(" SERIALIZABLE");
                break;
            }
            default: {
                throw new PSQLException("postgresql.con.isolevel", PSQLState.TRANSACTION_STATE_INVALID, new Integer(this.isolationLevel));
            }
        }
        return sb.toString();
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return this.PG_DATABASE;
    }

    public void finalize() throws Throwable {
        this.close();
    }

    private static String extractVersionNumber(String fullVersionString) {
        StringTokenizer versionParts = new StringTokenizer(fullVersionString);
        versionParts.nextToken();
        return versionParts.nextToken();
    }

    public String getDBVersionNumber() {
        return this.dbVersionNumber;
    }

    private static int integerPart(String dirtyString) {
        int end;
        int start;
        for (start = 0; start < dirtyString.length() && !Character.isDigit(dirtyString.charAt(start)); ++start) {
        }
        for (end = start; end < dirtyString.length() && Character.isDigit(dirtyString.charAt(end)); ++end) {
        }
        if (start == end) {
            return 0;
        }
        return Integer.parseInt(dirtyString.substring(start, end));
    }

    public int getServerMajorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.dbVersionNumber, ".");
            return AbstractJdbc1Connection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e2) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        try {
            StringTokenizer versionTokens = new StringTokenizer(this.dbVersionNumber, ".");
            versionTokens.nextToken();
            return AbstractJdbc1Connection.integerPart(versionTokens.nextToken());
        }
        catch (NoSuchElementException e2) {
            return 0;
        }
    }

    public boolean haveMinimumServerVersion(String ver) throws SQLException {
        return this.getDBVersionNumber().compareTo(ver) >= 0;
    }

    public boolean haveMinimumCompatibleVersion(String ver) throws SQLException {
        return this.compatible.compareTo(ver) >= 0;
    }

    public int getSQLType(int oid) throws SQLException {
        Integer sqlType = (Integer)sqlTypeCache.get(new Integer(oid));
        if (sqlType == null) {
            String pgType;
            if (oid == 0) {
                pgType = "opaque";
            } else {
                String sql = this.haveMinimumServerVersion("7.3") ? "SELECT typname FROM pg_catalog.pg_type WHERE oid = " + oid : "SELECT typname FROM pg_type WHERE oid = " + oid;
                BaseResultSet result = this.execSQL(sql);
                if (result.getColumnCount() != 1 || result.getTupleCount() != 1) {
                    throw new PSQLException("postgresql.unexpected", PSQLState.UNEXPECTED_ERROR);
                }
                result.next();
                pgType = result.getString(1);
                result.close();
            }
            Integer iOid = new Integer(oid);
            sqlType = new Integer(this.getSQLType(pgType));
            sqlTypeCache.put(iOid, sqlType);
            pgTypeCache.put(iOid, pgType);
        }
        return sqlType;
    }

    public int getPGType(String typeName) throws SQLException {
        int oid = -1;
        if (typeName != null) {
            Integer oidValue = (Integer)typeOidCache.get(typeName);
            if (oidValue != null) {
                oid = oidValue;
            } else {
                String sql = this.haveMinimumServerVersion("7.3") ? "SELECT oid FROM pg_catalog.pg_type WHERE typname='" + typeName + "'" : "SELECT oid FROM pg_type WHERE typname='" + typeName + "'";
                BaseResultSet result = this.execSQL(sql);
                if (result.getColumnCount() != 1 || result.getTupleCount() != 1) {
                    throw new PSQLException("postgresql.unexpected", PSQLState.UNEXPECTED_ERROR);
                }
                result.next();
                oid = Integer.parseInt(result.getString(1));
                typeOidCache.put(typeName, new Integer(oid));
                result.close();
            }
        }
        return oid;
    }

    public String getPGType(int oid) throws SQLException {
        String pgType = (String)pgTypeCache.get(new Integer(oid));
        if (pgType == null) {
            this.getSQLType(oid);
            pgType = (String)pgTypeCache.get(new Integer(oid));
        }
        return pgType;
    }

    protected void enableDriverManagerLogging() {
        if (DriverManager.getLogStream() == null) {
            DriverManager.setLogStream(System.out);
        }
    }

    public boolean isClosed() throws SQLException {
        return this.pgStream == null;
    }

    public int getSQLType(String pgTypeName) {
        int sqlType = 1111;
        for (int i2 = 0; i2 < jdbc1Types.length; ++i2) {
            if (!pgTypeName.equals(jdbc1Types[i2])) continue;
            sqlType = jdbc1Typei[i2];
            break;
        }
        return sqlType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancelQuery() throws SQLException {
        PGStream cancelStream = null;
        try {
            cancelStream = new PGStream(this.PG_HOST, this.PG_PORT);
        }
        catch (ConnectException cex) {
            throw new PSQLException("postgresql.con.refused", PSQLState.CONNECTION_REJECTED);
        }
        catch (IOException e2) {
            throw new PSQLException("postgresql.con.failed", PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Object)e2);
        }
        try {
            try {
                cancelStream.SendInteger(16, 4);
                cancelStream.SendInteger(80877102, 4);
                cancelStream.SendInteger(this.pid, 4);
                cancelStream.SendInteger(this.ckey, 4);
                cancelStream.flush();
            }
            catch (IOException e4) {
                throw new PSQLException("postgresql.con.failed", PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Object)e4);
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                if (cancelStream == null) throw throwable;
                cancelStream.close();
                throw throwable;
            }
            catch (IOException e3) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e3) {}
        if (cancelStream == null) return;
        cancelStream.close();
        return;
    }

    public void addNotification(PGNotification p_notification) {
        if (this.m_notifications == null) {
            this.m_notifications = new Vector();
        }
        this.m_notifications.addElement(p_notification);
    }

    public PGNotification[] getNotifications() {
        Object[] l_return = null;
        if (this.m_notifications != null) {
            l_return = new PGNotification[this.m_notifications.size()];
            this.m_notifications.copyInto(l_return);
        }
        this.m_notifications = null;
        return l_return;
    }
}

