/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc1;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseResultSet;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Encoding;
import org.postgresql.core.Field;
import org.postgresql.core.QueryExecutor;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PGbytea;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc1ResultSet
implements BaseResultSet {
    protected Vector rows;
    protected BaseStatement statement;
    protected Field[] fields;
    protected String status;
    protected int updateCount;
    protected long insertOID;
    protected int current_row;
    protected byte[][] this_row;
    protected BaseConnection connection;
    protected SQLWarning warnings = null;
    protected boolean wasNullFlag = false;
    protected BaseResultSet next = null;
    private StringBuffer sbuf = null;
    public byte[][] rowBuffer = null;
    private SimpleDateFormat m_tsFormat = null;
    private SimpleDateFormat m_tstzFormat = null;
    private SimpleDateFormat m_dateFormat = null;
    private int fetchSize;
    private int lastFetchSize;

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public AbstractJdbc1ResultSet(BaseStatement statement, Field[] fields, Vector tuples, String status, int updateCount, long insertOID) {
        this.connection = statement.getPGConnection();
        this.statement = statement;
        this.fields = fields;
        this.rows = tuples;
        this.status = status;
        this.updateCount = updateCount;
        this.insertOID = insertOID;
        this.this_row = null;
        this.current_row = -1;
        this.fetchSize = statement == null ? 0 : statement.getFetchSize();
        this.lastFetchSize = this.fetchSize;
    }

    public BaseStatement getPGStatement() {
        return this.statement;
    }

    public StringBuffer getStringBuffer() {
        return this.sbuf;
    }

    public void setStatement(BaseStatement statement) {
    }

    public void reInit(Field[] fields, Vector tuples, String status, int updateCount, long insertOID) {
        this.fields = fields;
        this.rows = tuples;
        this.status = status;
        this.updateCount = updateCount;
        this.insertOID = insertOID;
        this.this_row = null;
        this.current_row = -1;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public boolean next() throws SQLException {
        if (this.rows == null) {
            throw new PSQLException("postgresql.con.closed", PSQLState.CONNECTION_DOES_NOT_EXIST);
        }
        if (this.current_row + 1 >= this.rows.size()) {
            String cursorName = this.statement.getFetchingCursorName();
            if (cursorName == null || this.lastFetchSize == 0 || this.rows.size() < this.lastFetchSize) {
                this.current_row = this.rows.size();
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
            String[] sql = new String[]{this.fetchSize == 0 ? "FETCH FORWARD ALL FROM " + cursorName : "FETCH FORWARD " + this.fetchSize + " FROM " + cursorName};
            QueryExecutor.execute(sql, (Object[])new String[0], this);
            this.lastFetchSize = this.fetchSize;
            if (this.rows.size() == 0) {
                this.this_row = null;
                this.rowBuffer = null;
                return false;
            }
            this.current_row = 0;
        } else {
            ++this.current_row;
        }
        this.this_row = (byte[][])this.rows.elementAt(this.current_row);
        this.rowBuffer = new byte[this.this_row.length][];
        System.arraycopy(this.this_row, 0, this.rowBuffer, 0, this.this_row.length);
        return true;
    }

    public void close() throws SQLException {
        if (this.rows != null) {
            this.rows = null;
        }
    }

    public boolean wasNull() throws SQLException {
        return this.wasNullFlag;
    }

    public String getString(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        Encoding encoding = this.connection.getEncoding();
        return this.trimString(columnIndex, encoding.decode(this.this_row[columnIndex - 1]));
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toBoolean(this.getString(columnIndex));
    }

    public byte getByte(int columnIndex) throws SQLException {
        String s2 = this.getString(columnIndex);
        if (s2 != null) {
            try {
                switch (this.fields[columnIndex - 1].getSQLType()) {
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        int loc = s2.indexOf(".");
                        if (loc == -1 || Integer.parseInt(s2.substring(loc + 1, s2.length())) != 0) break;
                        s2 = s2.substring(0, loc);
                        break;
                    }
                    case 1: {
                        s2 = s2.trim();
                    }
                }
                return Byte.parseByte(s2);
            }
            catch (NumberFormatException e2) {
                throw new PSQLException("postgresql.res.badbyte", PSQLState.NUMERIC_VALUE_OUT_OF_RANGE, s2);
            }
        }
        return 0;
    }

    public short getShort(int columnIndex) throws SQLException {
        String s2 = this.getFixedString(columnIndex);
        if (s2 != null) {
            try {
                switch (this.fields[columnIndex - 1].getSQLType()) {
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        int loc = s2.indexOf(".");
                        if (loc == -1 || Integer.parseInt(s2.substring(loc + 1, s2.length())) != 0) break;
                        s2 = s2.substring(0, loc);
                        break;
                    }
                    case 1: {
                        s2 = s2.trim();
                    }
                }
                return Short.parseShort(s2);
            }
            catch (NumberFormatException e2) {
                throw new PSQLException("postgresql.res.badshort", PSQLState.NUMERIC_VALUE_OUT_OF_RANGE, s2);
            }
        }
        return 0;
    }

    public int getInt(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toInt(this.getFixedString(columnIndex));
    }

    public long getLong(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toLong(this.getFixedString(columnIndex));
    }

    public float getFloat(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toFloat(this.getFixedString(columnIndex));
    }

    public double getDouble(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toDouble(this.getFixedString(columnIndex));
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return AbstractJdbc1ResultSet.toBigDecimal(this.getFixedString(columnIndex), scale);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (!this.wasNullFlag) {
            if (this.fields[columnIndex - 1].getFormat() == 1) {
                return this.this_row[columnIndex - 1];
            }
            if (this.connection.haveMinimumCompatibleVersion("7.2")) {
                if (this.fields[columnIndex - 1].getPGType().equals("bytea")) {
                    return this.trimBytes(columnIndex, PGbytea.toBytes(this.this_row[columnIndex - 1]));
                }
                return this.trimBytes(columnIndex, this.this_row[columnIndex - 1]);
            }
            if (this.fields[columnIndex - 1].getOID() == 26) {
                LargeObjectManager lom = this.connection.getLargeObjectAPI();
                LargeObject lob = lom.open(this.getInt(columnIndex));
                byte[] buf = lob.read(lob.size());
                lob.close();
                return this.trimBytes(columnIndex, buf);
            }
            return this.trimBytes(columnIndex, this.this_row[columnIndex - 1]);
        }
        return null;
    }

    public Date getDate(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toDate(this.getString(columnIndex));
    }

    public Time getTime(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toTime(this.getString(columnIndex), this, this.fields[columnIndex - 1].getPGType());
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return AbstractJdbc1ResultSet.toTimestamp(this.getString(columnIndex), this, this.fields[columnIndex - 1].getPGType());
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            try {
                return new ByteArrayInputStream(this.getString(columnIndex).getBytes("ASCII"));
            }
            catch (UnsupportedEncodingException l_uee) {
                throw new PSQLException("postgresql.unusual", PSQLState.UNEXPECTED_ERROR, (Object)l_uee);
            }
        }
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            try {
                return new ByteArrayInputStream(this.getString(columnIndex).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException l_uee) {
                throw new PSQLException("postgresql.unusual", PSQLState.UNEXPECTED_ERROR, (Object)l_uee);
            }
        }
        return this.getBinaryStream(columnIndex);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        boolean bl = this.wasNullFlag = this.this_row[columnIndex - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            byte[] b2 = this.getBytes(columnIndex);
            if (b2 != null) {
                return new ByteArrayInputStream(b2);
            }
        } else if (this.fields[columnIndex - 1].getOID() == 26) {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            LargeObject lob = lom.open(this.getInt(columnIndex));
            return lob.getInputStream();
        }
        return null;
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void addWarnings(SQLWarning warnings) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(warnings);
        } else {
            this.warnings = warnings;
        }
    }

    public String getCursorName() throws SQLException {
        return this.connection.getCursorName();
    }

    public Object getObject(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange", PSQLState.INVALID_PARAMETER_VALUE);
        }
        Field field = this.fields[columnIndex - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        switch (field.getSQLType()) {
            case -7: {
                return this.getBoolean(columnIndex) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Short(this.getShort(columnIndex));
            }
            case 4: {
                return new Integer(this.getInt(columnIndex));
            }
            case -5: {
                return new Long(this.getLong(columnIndex));
            }
            case 2: {
                return this.getBigDecimal(columnIndex, field.getMod() == -1 ? -1 : field.getMod() - 4 & 0xFFFF);
            }
            case 7: {
                return new Float(this.getFloat(columnIndex));
            }
            case 8: {
                return new Double(this.getDouble(columnIndex));
            }
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
        }
        String type = field.getPGType();
        if (type.equals("unknown")) {
            return this.getString(columnIndex);
        }
        if (type.equals("refcursor")) {
            String cursorName = this.getString(columnIndex);
            return this.statement.createRefCursorResultSet(cursorName);
        }
        return this.connection.getObject(field.getPGType(), this.getString(columnIndex));
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        int flen = this.fields.length;
        for (int i2 = 0; i2 < flen; ++i2) {
            if (!this.fields[i2].getName().equalsIgnoreCase(columnName)) continue;
            return i2 + 1;
        }
        throw new PSQLException("postgresql.res.colname", (Object)columnName);
    }

    public boolean reallyResultSet() {
        return this.fields != null;
    }

    public ResultSet getNext() {
        return (ResultSet)((Object)this.next);
    }

    public void append(BaseResultSet r2) {
        if (this.next == null) {
            this.next = r2;
        } else {
            this.next.append(r2);
        }
    }

    public int getResultCount() {
        return this.updateCount;
    }

    public int getTupleCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.fields.length;
    }

    public String getStatusString() {
        return this.status;
    }

    public int getColumnOID(int field) {
        return this.fields[field - 1].getOID();
    }

    public int getInsertedOID() {
        return (int)this.getLastOID();
    }

    public long getLastOID() {
        return this.insertOID;
    }

    public String getFixedString(int col) throws SQLException {
        String s2 = this.getString(col);
        boolean bl = this.wasNullFlag = this.this_row[col - 1] == null;
        if (this.wasNullFlag) {
            return null;
        }
        if (s2.length() < 2) {
            return s2;
        }
        if (s2.charAt(0) == '(') {
            s2 = "-" + PGtokenizer.removePara(s2).substring(1);
        }
        if (s2.charAt(0) == '$') {
            s2 = s2.substring(1);
        } else if (s2.charAt(0) == '-' && s2.charAt(1) == '$') {
            s2 = "-" + s2.substring(2);
        }
        return s2;
    }

    protected void checkResultSet(int column) throws SQLException {
        if (this.this_row == null) {
            throw new PSQLException("postgresql.res.nextrequired");
        }
        if (column < 1 || column > this.fields.length) {
            throw new PSQLException("postgresql.res.colrange", PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    public static boolean toBoolean(String s2) {
        if (s2 != null) {
            if ((s2 = s2.trim()).equalsIgnoreCase("true") || s2.equalsIgnoreCase("t")) {
                return true;
            }
            try {
                if (Double.valueOf(s2) == 1.0) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int toInt(String s2) throws SQLException {
        if (s2 != null) {
            try {
                s2 = s2.trim();
                return Integer.parseInt(s2);
            }
            catch (NumberFormatException e2) {
                throw new PSQLException("postgresql.res.badint", PSQLState.NUMERIC_VALUE_OUT_OF_RANGE, s2);
            }
        }
        return 0;
    }

    public static long toLong(String s2) throws SQLException {
        if (s2 != null) {
            try {
                s2 = s2.trim();
                return Long.parseLong(s2);
            }
            catch (NumberFormatException e2) {
                throw new PSQLException("postgresql.res.badlong", PSQLState.NUMERIC_VALUE_OUT_OF_RANGE, s2);
            }
        }
        return 0L;
    }

    public static BigDecimal toBigDecimal(String s2, int scale) throws SQLException {
        if (s2 != null) {
            BigDecimal val;
            try {
                s2 = s2.trim();
                val = new BigDecimal(s2);
            }
            catch (NumberFormatException e2) {
                throw new PSQLException("postgresql.res.badbigdec", PSQLState.NUMERIC_VALUE_OUT_OF_RANGE, s2);
            }
            if (scale == -1) {
                return val;
            }
            try {
                return val.setScale(scale);
            }
            catch (ArithmeticException e3) {
                throw new PSQLException("postgresql.res.badbigdec", PSQLState.NUMERIC_VALUE_OUT_OF_RANGE, s2);
            }
        }
        return null;
    }

    public static float toFloat(String s2) throws SQLException {
        if (s2 != null) {
            try {
                s2 = s2.trim();
                return Float.valueOf(s2).floatValue();
            }
            catch (NumberFormatException e2) {
                throw new PSQLException("postgresql.res.badfloat", PSQLState.NUMERIC_VALUE_OUT_OF_RANGE, s2);
            }
        }
        return 0.0f;
    }

    public static double toDouble(String s2) throws SQLException {
        if (s2 != null) {
            try {
                s2 = s2.trim();
                return Double.valueOf(s2);
            }
            catch (NumberFormatException e2) {
                throw new PSQLException("postgresql.res.baddouble", PSQLState.NUMERIC_VALUE_OUT_OF_RANGE, s2);
            }
        }
        return 0.0;
    }

    public static Date toDate(String s2) throws SQLException {
        if (s2 == null) {
            return null;
        }
        try {
            s2 = s2.trim();
            return Date.valueOf(s2.length() == 10 ? s2 : s2.substring(0, 10));
        }
        catch (NumberFormatException e2) {
            throw new PSQLException("postgresql.res.baddate", PSQLState.BAD_DATETIME_FORMAT, s2);
        }
    }

    public static Time toTime(String s2, BaseResultSet resultSet, String pgDataType) throws SQLException {
        if (s2 == null) {
            return null;
        }
        try {
            s2 = s2.trim();
            if (s2.length() == 8) {
                return Time.valueOf(s2);
            }
            if (s2.indexOf(".") == 8) {
                int l_millis;
                Time l_time = Time.valueOf(s2.substring(0, 8));
                String l_strMillis = s2.substring(9);
                if (l_strMillis.length() > 3) {
                    l_strMillis = l_strMillis.substring(0, 3);
                }
                if ((l_millis = Integer.parseInt(l_strMillis)) < 10) {
                    l_millis *= 100;
                } else if (l_millis < 100) {
                    l_millis *= 10;
                }
                return new Time(l_time.getTime() + (long)l_millis);
            }
            return new Time(AbstractJdbc1ResultSet.toTimestamp(s2, resultSet, pgDataType).getTime());
        }
        catch (NumberFormatException e2) {
            throw new PSQLException("postgresql.res.badtime", PSQLState.BAD_DATETIME_FORMAT, s2);
        }
    }

    public static Timestamp toTimestamp(String s2, BaseResultSet resultSet, String pgDataType) throws SQLException {
        BaseResultSet rs = resultSet;
        if (s2 == null) {
            return null;
        }
        s2 = s2.trim();
        BaseResultSet baseResultSet = rs;
        synchronized (baseResultSet) {
            StringBuffer l_sbuf = rs.getStringBuffer();
            SimpleDateFormat df = null;
            if (Driver.logDebug) {
                Driver.debug("the data from the DB is " + s2);
            }
            if (l_sbuf == null) {
                l_sbuf = new StringBuffer(32);
            } else {
                l_sbuf.setLength(0);
            }
            l_sbuf.append(s2);
            int slen = s2.length();
            int nanos = 0;
            if (slen > 19) {
                int i2 = 19;
                l_sbuf.setLength(i2);
                char c2 = s2.charAt(i2++);
                if (c2 == '.') {
                    int start = i2;
                    while (Character.isDigit(c2 = s2.charAt(i2++))) {
                        if (i2 != slen) continue;
                        ++i2;
                        break;
                    }
                    int end = i2 - 1;
                    try {
                        nanos = Integer.parseInt(s2.substring(start, end));
                    }
                    catch (NumberFormatException e2) {
                        throw new PSQLException("postgresql.unusual", PSQLState.UNEXPECTED_ERROR, (Object)e2);
                    }
                    for (int digitsToNano = 9 - (end - start); digitsToNano > 0; --digitsToNano) {
                        nanos *= 10;
                    }
                }
                if (i2 < slen) {
                    l_sbuf.append(" GMT");
                    l_sbuf.append(c2);
                    l_sbuf.append(s2.substring(i2, slen));
                    if (slen - i2 < 5) {
                        l_sbuf.append(":00");
                    }
                    df = rs.getTimestampTZFormat();
                } else if (pgDataType.equals("timestamptz")) {
                    l_sbuf.append(" GMT");
                    df = rs.getTimestampTZFormat();
                } else {
                    df = rs.getTimestampFormat();
                }
            } else if (slen == 19) {
                if (pgDataType.equals("timestamptz")) {
                    l_sbuf.append(" GMT");
                    df = rs.getTimestampTZFormat();
                } else {
                    df = rs.getTimestampFormat();
                }
            } else {
                if (slen == 8 && s2.equals("infinity")) {
                    s2 = "9999-01-01";
                }
                if (slen == 9 && s2.equals("-infinity")) {
                    s2 = "0001-01-01";
                }
                df = rs.getDateFormat();
            }
            try {
                if (Driver.logDebug) {
                    Driver.debug("the data after parsing is " + l_sbuf.toString() + " with " + nanos + " nanos");
                }
                Timestamp result = new Timestamp(df.parse(l_sbuf.toString()).getTime());
                result.setNanos(nanos);
                return result;
            }
            catch (ParseException e3) {
                throw new PSQLException("postgresql.res.badtimestamp", PSQLState.BAD_DATETIME_FORMAT, new Integer(e3.getErrorOffset()), s2);
            }
        }
    }

    private boolean isColumnTrimmable(int columnIndex) throws SQLException {
        switch (this.fields[columnIndex - 1].getSQLType()) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private byte[] trimBytes(int p_columnIndex, byte[] p_bytes) throws SQLException {
        int l_maxSize = this.statement.getMaxFieldSize();
        if (l_maxSize > 0 && p_bytes.length > l_maxSize && this.isColumnTrimmable(p_columnIndex)) {
            byte[] l_bytes = new byte[l_maxSize];
            System.arraycopy(p_bytes, 0, l_bytes, 0, l_maxSize);
            return l_bytes;
        }
        return p_bytes;
    }

    private String trimString(int p_columnIndex, String p_string) throws SQLException {
        int l_maxSize = this.statement.getMaxFieldSize();
        if (l_maxSize > 0 && p_string.length() > l_maxSize && this.isColumnTrimmable(p_columnIndex)) {
            return p_string.substring(0, l_maxSize);
        }
        return p_string;
    }

    public SimpleDateFormat getTimestampTZFormat() {
        if (this.m_tstzFormat == null) {
            this.m_tstzFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        }
        return this.m_tstzFormat;
    }

    public SimpleDateFormat getTimestampFormat() {
        if (this.m_tsFormat == null) {
            this.m_tsFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return this.m_tsFormat;
    }

    public SimpleDateFormat getDateFormat() {
        if (this.m_dateFormat == null) {
            this.m_dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        }
        return this.m_dateFormat;
    }
}

