/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc1;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseResultSet;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Field;
import org.postgresql.core.QueryExecutor;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PGbytea;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc1Statement
implements BaseStatement {
    protected BaseConnection connection;
    protected SQLWarning warnings = null;
    protected int maxrows = 0;
    protected int fetchSize = 0;
    protected int timeout = 0;
    protected boolean replaceProcessingEnabled = true;
    protected BaseResultSet result = null;
    private static final short IN_SQLCODE = 0;
    private static final short IN_STRING = 1;
    private static final short BACKSLASH = 2;
    private static final short ESC_TIMEDATE = 3;
    private StringBuffer sbuf = new StringBuffer(32);
    protected String[] m_sqlFragments;
    private String[] m_executeSqlFragments;
    protected Object[] m_binds = new Object[0];
    protected String[] m_bindTypes = new String[0];
    protected String m_statementName = null;
    protected String m_cursorName = null;
    private static final short UNKNOWN = 0;
    private static final short NO = 1;
    private static final short YES = 2;
    private short m_isSingleDML = 0;
    private short m_isSingleSelect = 0;
    private short m_isSingleStatement = 0;
    private boolean m_useServerPrepare = false;
    private boolean isClosed = false;
    private static int m_preparedCount = 1;
    private static final String JDBC_SYNTAX = "{[? =] call <some_function> ([? [,?]*]) }";
    private static final String RESULT_ALIAS = "result";
    private String originalSql = "";
    private boolean isFunction;
    private int functionReturnType;
    private int testReturn;
    private boolean returnTypeSet;
    protected Object callResult;
    protected int maxfieldSize = 0;
    private static final String PG_TEXT = "text";
    private static final String PG_INTEGER = "integer";
    private static final String PG_INT2 = "int2";
    private static final String PG_INT8 = "int8";
    private static final String PG_NUMERIC = "numeric";
    private static final String PG_FLOAT = "float";
    private static final String PG_DOUBLE = "double precision";
    private static final String PG_BOOLEAN = "boolean";
    private static final String PG_DATE = "date";
    private static final String PG_TIME = "time";
    private static final String PG_TIMESTAMPTZ = "timestamptz";
    private static final String PG_BYTEA = "bytea";

    private static synchronized int next_preparedCount() {
        return m_preparedCount++;
    }

    public abstract BaseResultSet createResultSet(Field[] var1, Vector var2, String var3, int var4, long var5) throws SQLException;

    public AbstractJdbc1Statement(BaseConnection connection) {
        this.connection = connection;
    }

    public AbstractJdbc1Statement(BaseConnection connection, String p_sql) throws SQLException {
        this.connection = connection;
        this.parseSqlStmt(p_sql);
    }

    public BaseConnection getPGConnection() {
        return this.connection;
    }

    public String getFetchingCursorName() {
        return this.m_cursorName;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    protected void parseSqlStmt(String p_sql) throws SQLException {
        int i2;
        String l_sql = p_sql;
        l_sql = this.replaceProcessing(l_sql);
        if (this instanceof CallableStatement) {
            l_sql = this.modifyJdbcCall(l_sql);
        }
        Vector<String> v2 = new Vector<String>();
        boolean inQuotes = false;
        int lastParmEnd = 0;
        this.m_isSingleDML = 0;
        this.m_isSingleSelect = 0;
        this.m_isSingleStatement = (short)2;
        for (i2 = 0; i2 < l_sql.length(); ++i2) {
            char c2 = l_sql.charAt(i2);
            if (c2 == '\'') {
                boolean bl = inQuotes = !inQuotes;
            }
            if (c2 == '?' && !inQuotes) {
                v2.addElement(l_sql.substring(lastParmEnd, i2));
                lastParmEnd = i2 + 1;
            }
            if (c2 != ';' || inQuotes) continue;
            this.m_isSingleDML = 1;
            this.m_isSingleSelect = 1;
            this.m_isSingleStatement = 1;
        }
        v2.addElement(l_sql.substring(lastParmEnd, l_sql.length()));
        this.m_sqlFragments = new String[v2.size()];
        this.m_binds = new Object[v2.size() - 1];
        this.m_bindTypes = new String[v2.size() - 1];
        for (i2 = 0; i2 < this.m_sqlFragments.length; ++i2) {
            this.m_sqlFragments[i2] = (String)v2.elementAt(i2);
        }
    }

    private void deallocateQuery() {
        if (this.m_statementName != null) {
            try {
                this.connection.execSQL("DEALLOCATE " + this.m_statementName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_statementName = null;
        this.m_cursorName = null;
        this.m_executeSqlFragments = null;
        this.m_isSingleDML = 0;
        this.m_isSingleSelect = 0;
        this.m_isSingleStatement = 0;
    }

    public ResultSet executeQuery(String p_sql) throws SQLException {
        this.deallocateQuery();
        String l_sql = this.replaceProcessing(p_sql);
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        return this.executeQuery();
    }

    public ResultSet executeQuery() throws SQLException {
        this.execute();
        while (this.result != null && !this.result.reallyResultSet()) {
            this.result = (BaseResultSet)((Object)this.result.getNext());
        }
        if (this.result == null) {
            throw new PSQLException("postgresql.stat.noresult", PSQLState.NO_DATA);
        }
        return (ResultSet)((Object)this.result);
    }

    public int executeUpdate(String p_sql) throws SQLException {
        this.deallocateQuery();
        String l_sql = this.replaceProcessing(p_sql);
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        return this.executeUpdate();
    }

    public int executeUpdate() throws SQLException {
        this.execute();
        if (this.result.reallyResultSet()) {
            throw new PSQLException("postgresql.stat.result");
        }
        return this.getUpdateCount();
    }

    public boolean execute(String p_sql) throws SQLException {
        this.deallocateQuery();
        String l_sql = this.replaceProcessing(p_sql);
        this.m_sqlFragments = new String[]{l_sql};
        this.m_binds = new Object[0];
        return this.execute();
    }

    private boolean isSingleStatement() {
        if (this.m_isSingleStatement != 0) {
            return this.m_isSingleStatement == 2;
        }
        for (int i2 = 0; i2 < this.m_sqlFragments.length; ++i2) {
            if (this.m_sqlFragments[i2].indexOf(59) == -1) continue;
            this.m_isSingleStatement = 1;
            return false;
        }
        this.m_isSingleStatement = (short)2;
        return true;
    }

    private void analyzeStatementType() {
        if (!this.isSingleStatement()) {
            this.m_isSingleDML = 1;
            this.m_isSingleSelect = 1;
            return;
        }
        String compare = this.m_sqlFragments[0].trim().toLowerCase();
        if (compare.startsWith("select")) {
            this.m_isSingleDML = (short)2;
            this.m_isSingleSelect = (short)2;
            return;
        }
        this.m_isSingleSelect = 1;
        if (!(compare.startsWith("update") || compare.startsWith("delete") || compare.startsWith("insert"))) {
            this.m_isSingleDML = 1;
            return;
        }
        this.m_isSingleDML = (short)2;
    }

    private boolean isSingleSelect() {
        if (this.m_isSingleSelect == 0) {
            this.analyzeStatementType();
        }
        return this.m_isSingleSelect == 2;
    }

    private boolean isSingleDML() {
        if (this.m_isSingleDML == 0) {
            this.analyzeStatementType();
        }
        return this.m_isSingleDML == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] transformToServerPrepare() {
        if (this.m_statementName != null) {
            return this.m_executeSqlFragments;
        }
        this.m_statementName = "JDBC_STATEMENT_" + m_preparedCount++;
        this.m_executeSqlFragments = new String[this.m_sqlFragments.length];
        this.m_executeSqlFragments[0] = "EXECUTE " + this.m_statementName;
        if (this.m_sqlFragments.length > 1) {
            this.m_executeSqlFragments[0] = this.m_executeSqlFragments[0] + "(";
            for (int i2 = 1; i2 < this.m_bindTypes.length; ++i2) {
                this.m_executeSqlFragments[i2] = ", ";
            }
            this.m_executeSqlFragments[this.m_bindTypes.length] = ")";
        }
        String[] prepareSqlFragments = new String[this.m_sqlFragments.length];
        System.arraycopy(this.m_sqlFragments, 0, prepareSqlFragments, 0, this.m_sqlFragments.length);
        StringBuffer stringBuffer = this.sbuf;
        synchronized (stringBuffer) {
            int i3;
            this.sbuf.setLength(0);
            this.sbuf.append("PREPARE ");
            this.sbuf.append(this.m_statementName);
            if (this.m_sqlFragments.length > 1) {
                this.sbuf.append("(");
                for (i3 = 0; i3 < this.m_bindTypes.length; ++i3) {
                    if (i3 != 0) {
                        this.sbuf.append(", ");
                    }
                    this.sbuf.append(this.m_bindTypes[i3]);
                }
                this.sbuf.append(")");
            }
            this.sbuf.append(" AS ");
            this.sbuf.append(this.m_sqlFragments[0]);
            for (i3 = 1; i3 < this.m_sqlFragments.length; ++i3) {
                this.sbuf.append(" $");
                this.sbuf.append(i3);
                this.sbuf.append(" ");
                this.sbuf.append(this.m_sqlFragments[i3]);
            }
            this.sbuf.append("; ");
            this.sbuf.append(this.m_executeSqlFragments[0]);
            prepareSqlFragments[0] = this.sbuf.toString();
        }
        System.arraycopy(this.m_executeSqlFragments, 1, prepareSqlFragments, 1, prepareSqlFragments.length - 1);
        return prepareSqlFragments;
    }

    private String[] transformToCursorFetch() {
        this.m_cursorName = "JDBC_CURS_" + m_preparedCount++;
        int len = this.m_sqlFragments.length;
        String[] cursorBasedSql = new String[len];
        System.arraycopy(this.m_sqlFragments, 0, cursorBasedSql, 0, len);
        cursorBasedSql[0] = "DECLARE " + this.m_cursorName + " CURSOR FOR " + cursorBasedSql[0];
        int n2 = len - 1;
        cursorBasedSql[n2] = cursorBasedSql[n2] + "; FETCH FORWARD " + this.fetchSize + " FROM " + this.m_cursorName;
        if (Driver.logDebug) {
            Driver.debug("using cursor based sql with cursor name " + this.m_cursorName);
        }
        return cursorBasedSql;
    }

    private String[] getQueryFragments() {
        if (this.fetchSize > 0 && !this.connection.getAutoCommit() && this.isSingleSelect()) {
            return this.transformToCursorFetch();
        }
        if (this.isUseServerPrepare() && this.isSingleDML()) {
            return this.transformToServerPrepare();
        }
        return this.m_sqlFragments;
    }

    public boolean execute() throws SQLException {
        ResultSet rs;
        if (this.isFunction && !this.returnTypeSet) {
            throw new PSQLException("postgresql.call.noreturntype", PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (this.isFunction) {
            this.m_binds[0] = "";
            this.m_bindTypes[0] = PG_TEXT;
        }
        if (this.result != null && (rs = this.getResultSet()) != null) {
            rs.close();
        }
        String[] fragments = this.getQueryFragments();
        this.result = QueryExecutor.execute(fragments, this.m_binds, this);
        if (this.isFunction) {
            if (!this.result.reallyResultSet()) {
                throw new PSQLException("postgresql.call.noreturnval", PSQLState.NO_DATA);
            }
            if (!this.result.next()) {
                throw new PSQLException("postgresql.call.noreturnval", PSQLState.NO_DATA);
            }
            this.callResult = this.result.getObject(1);
            int columnType = this.result.getMetaData().getColumnType(1);
            if (columnType != this.functionReturnType) {
                throw new PSQLException("postgresql.call.wrongrtntype", PSQLState.DATA_TYPE_MISMATCH, new Object[]{"java.sql.Types=" + columnType, "java.sql.Types=" + this.functionReturnType});
            }
            this.result.close();
            return true;
        }
        return this.result != null && this.result.reallyResultSet();
    }

    public void setCursorName(String name) throws SQLException {
        this.connection.setCursorName(name);
    }

    public int getUpdateCount() throws SQLException {
        if (this.result == null) {
            return -1;
        }
        if (this.isFunction) {
            return 1;
        }
        if (this.result.reallyResultSet()) {
            return -1;
        }
        return this.result.getResultCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.result = (BaseResultSet)((Object)this.result.getNext());
        return this.result != null && this.result.reallyResultSet();
    }

    public String getResultStatusString() {
        if (this.result == null) {
            return null;
        }
        return this.result.getStatusString();
    }

    public int getMaxRows() throws SQLException {
        return this.maxrows;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new PSQLException("postgresql.input.rows.gt0");
        }
        this.maxrows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.replaceProcessingEnabled = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new PSQLException("postgresql.input.query.gt0");
        }
        this.timeout = seconds;
    }

    public void addWarning(String msg) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(new SQLWarning(msg));
        } else {
            this.warnings = new SQLWarning(msg);
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxfieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw new PSQLException("postgresql.input.field.gt0");
        }
        this.maxfieldSize = max;
    }

    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    public void cancel() throws SQLException {
        throw new PSQLException("postgresql.unimplemented", PSQLState.NOT_IMPLEMENTED);
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.result != null && this.result.reallyResultSet()) {
            return (ResultSet)((Object)this.result);
        }
        return null;
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            rs.close();
        }
        this.deallocateQuery();
        this.result = null;
        this.isClosed = true;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected String replaceProcessing(String p_sql) {
        if (this.replaceProcessingEnabled) {
            StringBuffer newsql = new StringBuffer(p_sql.length());
            int state = 0;
            int i2 = -1;
            int len = p_sql.length();
            while (++i2 < len) {
                char c2 = p_sql.charAt(i2);
                switch (state) {
                    case 0: {
                        if (c2 == '\'') {
                            state = 1;
                        } else if (c2 == '{' && i2 + 1 < len) {
                            char next = p_sql.charAt(i2 + 1);
                            if (next == 'd') {
                                state = 3;
                                ++i2;
                                break;
                            }
                            if (next == 't') {
                                state = 3;
                                i2 += i2 + 2 < len && p_sql.charAt(i2 + 2) == 's' ? 2 : 1;
                                break;
                            }
                        }
                        newsql.append(c2);
                        break;
                    }
                    case 1: {
                        if (c2 == '\'') {
                            state = 0;
                        } else if (c2 == '\\') {
                            state = 2;
                        }
                        newsql.append(c2);
                        break;
                    }
                    case 2: {
                        state = 1;
                        newsql.append(c2);
                        break;
                    }
                    case 3: {
                        if (c2 == '}') {
                            state = 0;
                            break;
                        }
                        newsql.append(c2);
                    }
                }
            }
            return newsql.toString();
        }
        return p_sql;
    }

    public int getInsertedOID() throws SQLException {
        if (this.result == null) {
            return 0;
        }
        return (int)this.result.getLastOID();
    }

    public long getLastOID() throws SQLException {
        if (this.result == null) {
            return 0L;
        }
        return this.result.getLastOID();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        String l_pgType;
        switch (sqlType) {
            case 4: {
                l_pgType = PG_INTEGER;
                break;
            }
            case -6: 
            case 5: {
                l_pgType = PG_INT2;
                break;
            }
            case -5: {
                l_pgType = PG_INT8;
                break;
            }
            case 6: 
            case 7: {
                l_pgType = PG_FLOAT;
                break;
            }
            case 8: {
                l_pgType = PG_DOUBLE;
                break;
            }
            case 2: 
            case 3: {
                l_pgType = PG_NUMERIC;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                l_pgType = PG_TEXT;
                break;
            }
            case 91: {
                l_pgType = PG_DATE;
                break;
            }
            case 92: {
                l_pgType = PG_TIME;
                break;
            }
            case 93: {
                l_pgType = PG_TIMESTAMPTZ;
                break;
            }
            case -7: {
                l_pgType = PG_BOOLEAN;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                l_pgType = PG_BYTEA;
                break;
            }
            case 1111: {
                l_pgType = PG_TEXT;
                break;
            }
            default: {
                l_pgType = PG_TEXT;
            }
        }
        this.bind(parameterIndex, "null", l_pgType);
    }

    public void setBoolean(int parameterIndex, boolean x2) throws SQLException {
        this.bind(parameterIndex, x2 ? "'1'" : "'0'", PG_BOOLEAN);
    }

    public void setByte(int parameterIndex, byte x2) throws SQLException {
        this.bind(parameterIndex, Integer.toString(x2), PG_INT2);
    }

    public void setShort(int parameterIndex, short x2) throws SQLException {
        this.bind(parameterIndex, Integer.toString(x2), PG_INT2);
    }

    public void setInt(int parameterIndex, int x2) throws SQLException {
        this.bind(parameterIndex, Integer.toString(x2), PG_INTEGER);
    }

    public void setLong(int parameterIndex, long x2) throws SQLException {
        this.bind(parameterIndex, Long.toString(x2), PG_INT8);
    }

    public void setFloat(int parameterIndex, float x2) throws SQLException {
        this.bind(parameterIndex, Float.toString(x2), PG_FLOAT);
    }

    public void setDouble(int parameterIndex, double x2) throws SQLException {
        this.bind(parameterIndex, Double.toString(x2), PG_DOUBLE);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x2) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.bind(parameterIndex, x2.toString(), PG_NUMERIC);
        }
    }

    public void setString(int parameterIndex, String x2) throws SQLException {
        this.setString(parameterIndex, x2, PG_TEXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int parameterIndex, String x2, String type) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 12);
        } else {
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.ensureCapacity(2 + x2.length() + x2.length() / 10);
                this.sbuf.append('\'');
                this.escapeString(x2, this.sbuf);
                this.sbuf.append('\'');
                this.bind(parameterIndex, this.sbuf.toString(), type);
            }
        }
    }

    private void escapeString(String p_input, StringBuffer p_output) {
        block4: for (int i2 = 0; i2 < p_input.length(); ++i2) {
            char c2 = p_input.charAt(i2);
            switch (c2) {
                case '\'': 
                case '\\': {
                    p_output.append('\\');
                    p_output.append(c2);
                    continue block4;
                }
                case '\u0000': {
                    throw new IllegalArgumentException("\\0 not allowed");
                }
                default: {
                    p_output.append(c2);
                }
            }
        }
    }

    public void setBytes(int parameterIndex, byte[] x2) throws SQLException {
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            if (null == x2) {
                this.setNull(parameterIndex, -3);
            } else {
                this.setString(parameterIndex, PGbytea.toPGString(x2), PG_BYTEA);
            }
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            int oid = lom.create();
            LargeObject lob = lom.open(oid);
            lob.write(x2);
            lob.close();
            this.setInt(parameterIndex, oid);
        }
    }

    public void setDate(int parameterIndex, Date x2) throws SQLException {
        if (null == x2) {
            this.setNull(parameterIndex, 91);
        } else {
            this.bind(parameterIndex, "'" + x2.toString() + "'", PG_DATE);
        }
    }

    public void setTime(int parameterIndex, Time x2) throws SQLException {
        if (null == x2) {
            this.setNull(parameterIndex, 92);
        } else {
            this.bind(parameterIndex, "'" + x2.toString() + "'", PG_TIME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(int parameterIndex, Timestamp x2) throws SQLException {
        if (null == x2) {
            this.setNull(parameterIndex, 93);
        } else {
            StringBuffer stringBuffer = this.sbuf;
            synchronized (stringBuffer) {
                this.sbuf.setLength(0);
                this.sbuf.ensureCapacity(32);
                this.sbuf.append("'");
                int l_year = x2.getYear() + 1900;
                int l_yearlen = String.valueOf(l_year).length();
                for (int i2 = 4; i2 > l_yearlen; --i2) {
                    this.sbuf.append("0");
                }
                this.sbuf.append(l_year);
                this.sbuf.append('-');
                int l_month = x2.getMonth() + 1;
                if (l_month < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_month);
                this.sbuf.append('-');
                int l_day = x2.getDate();
                if (l_day < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_day);
                this.sbuf.append(' ');
                int l_hours = x2.getHours();
                if (l_hours < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_hours);
                this.sbuf.append(':');
                int l_minutes = x2.getMinutes();
                if (l_minutes < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_minutes);
                this.sbuf.append(':');
                int l_seconds = x2.getSeconds();
                if (l_seconds < 10) {
                    this.sbuf.append('0');
                }
                this.sbuf.append(l_seconds);
                char[] l_decimal = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
                char[] l_nanos = Integer.toString(x2.getNanos()).toCharArray();
                System.arraycopy(l_nanos, 0, l_decimal, l_decimal.length - l_nanos.length, l_nanos.length);
                this.sbuf.append('.');
                if (this.connection.haveMinimumServerVersion("7.2")) {
                    this.sbuf.append(l_decimal, 0, 6);
                } else {
                    this.sbuf.append(l_decimal, 0, 2);
                }
                int l_offset = -x2.getTimezoneOffset();
                int l_houros = l_offset / 60;
                if (l_houros >= 0) {
                    this.sbuf.append('+');
                } else {
                    this.sbuf.append('-');
                }
                if (l_houros > -10 && l_houros < 10) {
                    this.sbuf.append('0');
                }
                if (l_houros >= 0) {
                    this.sbuf.append(l_houros);
                } else {
                    this.sbuf.append(-l_houros);
                }
                int l_minos = l_offset - l_houros * 60;
                if (l_minos != 0) {
                    if (l_minos > -10 && l_minos < 10) {
                        this.sbuf.append('0');
                    }
                    if (l_minos >= 0) {
                        this.sbuf.append(l_minos);
                    } else {
                        this.sbuf.append(-l_minos);
                    }
                }
                this.sbuf.append("'");
                this.bind(parameterIndex, this.sbuf.toString(), PG_TIMESTAMPTZ);
            }
        }
    }

    private void setCharacterStreamPost71(int parameterIndex, InputStream x2, int length, String encoding) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 12);
            return;
        }
        try {
            int n2;
            InputStreamReader l_inStream = new InputStreamReader(x2, encoding);
            char[] l_chars = new char[length];
            int l_charsRead = 0;
            while ((n2 = l_inStream.read(l_chars, l_charsRead, length - l_charsRead)) != -1 && (l_charsRead += n2) != length) {
            }
            this.setString(parameterIndex, new String(l_chars, 0, l_charsRead), PG_TEXT);
        }
        catch (UnsupportedEncodingException l_uee) {
            throw new PSQLException("postgresql.unusual", PSQLState.UNEXPECTED_ERROR, (Object)l_uee);
        }
        catch (IOException l_ioe) {
            throw new PSQLException("postgresql.unusual", PSQLState.UNEXPECTED_ERROR, (Object)l_ioe);
        }
    }

    public void setAsciiStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            this.setCharacterStreamPost71(parameterIndex, x2, length, "ASCII");
        } else {
            this.setBinaryStream(parameterIndex, x2, length);
        }
    }

    public void setUnicodeStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            this.setCharacterStreamPost71(parameterIndex, x2, length, "UTF-8");
        } else {
            this.setBinaryStream(parameterIndex, x2, length);
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x2, int length) throws SQLException {
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            if (x2 == null) {
                this.setNull(parameterIndex, -3);
                return;
            }
            byte[] l_bytes = new byte[length];
            int l_bytesRead = 0;
            try {
                int n2;
                while ((n2 = x2.read(l_bytes, l_bytesRead, length - l_bytesRead)) != -1 && (l_bytesRead += n2) != length) {
                }
            }
            catch (IOException l_ioe) {
                throw new PSQLException("postgresql.unusual", PSQLState.UNEXPECTED_ERROR, (Object)l_ioe);
            }
            if (l_bytesRead == length) {
                this.setBytes(parameterIndex, l_bytes);
            } else {
                byte[] l_bytes2 = new byte[l_bytesRead];
                System.arraycopy(l_bytes, 0, l_bytes2, 0, l_bytesRead);
                this.setBytes(parameterIndex, l_bytes2);
            }
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            int oid = lom.create();
            LargeObject lob = lom.open(oid);
            OutputStream los = lob.getOutputStream();
            try {
                int c2 = x2.read();
                for (int p2 = 0; c2 > -1 && p2 < length; ++p2) {
                    los.write(c2);
                    c2 = x2.read();
                }
                los.close();
            }
            catch (IOException se) {
                throw new PSQLException("postgresql.unusual", PSQLState.UNEXPECTED_ERROR, (Object)se);
            }
            this.setInt(parameterIndex, oid);
        }
    }

    public void clearParameters() throws SQLException {
        for (int i2 = 0; i2 < this.m_binds.length; ++i2) {
            this.m_binds[i2] = null;
            this.m_bindTypes[i2] = null;
        }
    }

    private String numericValueOf(Object x2) {
        if (x2 instanceof Boolean) {
            return (Boolean)x2 != false ? "1" : "0";
        }
        if (x2 instanceof Integer || x2 instanceof Long || x2 instanceof Double || x2 instanceof Short || x2 instanceof Number || x2 instanceof Float) {
            return x2.toString();
        }
        return new BigDecimal(x2.toString()).toString();
    }

    public void setObject(int parameterIndex, Object x2, int targetSqlType, int scale) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case 4: {
                this.bind(parameterIndex, this.numericValueOf(x2), PG_INTEGER);
                break;
            }
            case -6: 
            case 5: {
                this.bind(parameterIndex, this.numericValueOf(x2), PG_INT2);
                break;
            }
            case -5: {
                this.bind(parameterIndex, this.numericValueOf(x2), PG_INT8);
                break;
            }
            case 6: 
            case 7: {
                this.bind(parameterIndex, this.numericValueOf(x2), PG_FLOAT);
                break;
            }
            case 8: {
                this.bind(parameterIndex, this.numericValueOf(x2), PG_DOUBLE);
                break;
            }
            case 2: 
            case 3: {
                this.bind(parameterIndex, this.numericValueOf(x2), PG_NUMERIC);
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, x2.toString());
                break;
            }
            case 91: {
                if (x2 instanceof Date) {
                    this.setDate(parameterIndex, (Date)x2);
                    break;
                }
                Date tmpd = x2 instanceof java.util.Date ? new Date(((java.util.Date)x2).getTime()) : this.dateFromString(x2.toString());
                this.setDate(parameterIndex, tmpd);
                break;
            }
            case 92: {
                if (x2 instanceof Time) {
                    this.setTime(parameterIndex, (Time)x2);
                    break;
                }
                Time tmpt = x2 instanceof java.util.Date ? new Time(((java.util.Date)x2).getTime()) : this.timeFromString(x2.toString());
                this.setTime(parameterIndex, tmpt);
                break;
            }
            case 93: {
                if (x2 instanceof Timestamp) {
                    this.setTimestamp(parameterIndex, (Timestamp)x2);
                    break;
                }
                Timestamp tmpts = x2 instanceof java.util.Date ? new Timestamp(((java.util.Date)x2).getTime()) : this.timestampFromString(x2.toString());
                this.setTimestamp(parameterIndex, tmpts);
                break;
            }
            case -7: {
                if (x2 instanceof Boolean) {
                    this.bind(parameterIndex, (Boolean)x2 != false ? "'1'" : "'0'", PG_BOOLEAN);
                    break;
                }
                if (x2 instanceof String) {
                    this.bind(parameterIndex, Boolean.valueOf(x2.toString()) != false ? "'1'" : "'0'", PG_BOOLEAN);
                    break;
                }
                if (x2 instanceof Number) {
                    this.bind(parameterIndex, ((Number)x2).intValue() != 0 ? "'1'" : "'0'", PG_BOOLEAN);
                    break;
                }
                throw new PSQLException("postgresql.prep.type", PSQLState.INVALID_PARAMETER_TYPE);
            }
            case -4: 
            case -3: 
            case -2: {
                this.setObject(parameterIndex, x2);
                break;
            }
            case 1111: {
                if (x2 instanceof PGobject) {
                    this.setString(parameterIndex, ((PGobject)x2).getValue(), ((PGobject)x2).getType());
                    break;
                }
                throw new PSQLException("postgresql.prep.type", PSQLState.INVALID_PARAMETER_TYPE);
            }
            default: {
                throw new PSQLException("postgresql.prep.type", PSQLState.INVALID_PARAMETER_TYPE);
            }
        }
    }

    public void setObject(int parameterIndex, Object x2, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x2, targetSqlType, 0);
    }

    public void setObject(int parameterIndex, Object x2) throws SQLException {
        if (x2 == null) {
            this.setNull(parameterIndex, 1111);
            return;
        }
        if (x2 instanceof String) {
            this.setString(parameterIndex, (String)x2);
        } else if (x2 instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x2);
        } else if (x2 instanceof Short) {
            this.setShort(parameterIndex, (Short)x2);
        } else if (x2 instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x2);
        } else if (x2 instanceof Long) {
            this.setLong(parameterIndex, (Long)x2);
        } else if (x2 instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x2).floatValue());
        } else if (x2 instanceof Double) {
            this.setDouble(parameterIndex, (Double)x2);
        } else if (x2 instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x2);
        } else if (x2 instanceof Date) {
            this.setDate(parameterIndex, (Date)x2);
        } else if (x2 instanceof Time) {
            this.setTime(parameterIndex, (Time)x2);
        } else if (x2 instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x2);
        } else if (x2 instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x2);
        } else if (x2 instanceof PGobject) {
            this.setString(parameterIndex, ((PGobject)x2).getValue(), PG_TEXT);
        } else {
            this.setString(parameterIndex, x2.toString(), PG_TEXT);
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if (parameterIndex != 1) {
            throw new PSQLException("postgresql.call.noinout", PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (!this.isFunction) {
            throw new PSQLException("postgresql.call.procasfunc", PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL, this.originalSql);
        }
        this.functionReturnType = sqlType;
        this.testReturn = sqlType;
        if (this.functionReturnType == 1 || this.functionReturnType == -1) {
            this.testReturn = 12;
        } else if (this.functionReturnType == 6) {
            this.testReturn = 7;
        }
        this.returnTypeSet = true;
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    public boolean wasNull() throws SQLException {
        return this.callResult == null;
    }

    public String getString(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 12, "String");
        return (String)this.callResult;
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, -7, "Boolean");
        if (this.callResult == null) {
            return false;
        }
        return (Boolean)this.callResult;
    }

    public byte getByte(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, -6, "Byte");
        if (this.callResult == null) {
            return 0;
        }
        return (byte)((Integer)this.callResult).intValue();
    }

    public short getShort(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 5, "Short");
        if (this.callResult == null) {
            return 0;
        }
        return (short)((Integer)this.callResult).intValue();
    }

    public int getInt(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 4, "Int");
        if (this.callResult == null) {
            return 0;
        }
        return (Integer)this.callResult;
    }

    public long getLong(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, -5, "Long");
        if (this.callResult == null) {
            return 0L;
        }
        return (Long)this.callResult;
    }

    public float getFloat(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 7, "Float");
        if (this.callResult == null) {
            return 0.0f;
        }
        return ((Float)this.callResult).floatValue();
    }

    public double getDouble(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 8, "Double");
        if (this.callResult == null) {
            return 0.0;
        }
        return (Double)this.callResult;
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult;
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, -3, -2, "Bytes");
        return (byte[])this.callResult;
    }

    public Date getDate(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 91, "Date");
        return (Date)this.callResult;
    }

    public Time getTime(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 92, "Time");
        return (Time)this.callResult;
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 93, "Timestamp");
        return (Timestamp)this.callResult;
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex);
        return this.callResult;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.m_sqlFragments == null) {
            return super.toString();
        }
        StringBuffer stringBuffer = this.sbuf;
        synchronized (stringBuffer) {
            this.sbuf.setLength(0);
            for (int i2 = 0; i2 < this.m_binds.length; ++i2) {
                this.sbuf.append(this.m_sqlFragments[i2]);
                if (this.m_binds[i2] == null) {
                    this.sbuf.append('?');
                    continue;
                }
                this.sbuf.append(this.m_binds[i2]);
            }
            this.sbuf.append(this.m_sqlFragments[this.m_binds.length]);
            return this.sbuf.toString();
        }
    }

    private void bind(int paramIndex, Object s2, String type) throws SQLException {
        if (paramIndex < 1 || paramIndex > this.m_binds.length) {
            throw new PSQLException("postgresql.prep.range", PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (paramIndex == 1 && this.isFunction) {
            throw new PSQLException("postgresql.call.funcover");
        }
        this.m_binds[paramIndex - 1] = s2;
        this.m_bindTypes[paramIndex - 1] = type;
    }

    private String modifyJdbcCall(String p_sql) throws SQLException {
        if (!p_sql.trim().startsWith("{")) {
            return p_sql;
        }
        this.originalSql = p_sql;
        String l_sql = p_sql;
        int index = l_sql.indexOf("=");
        boolean isValid = true;
        if (index > -1) {
            this.isFunction = true;
            boolean bl = isValid = l_sql.indexOf("?") < index;
        }
        if ((l_sql = l_sql.trim()).startsWith("{") && l_sql.endsWith("}")) {
            l_sql = l_sql.substring(1, l_sql.length() - 1);
        } else {
            isValid = false;
        }
        index = l_sql.indexOf("call");
        if (index == -1 || !isValid) {
            throw new PSQLException("postgresql.call.malformed", PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL, new Object[]{l_sql, JDBC_SYNTAX});
        }
        l_sql = l_sql.replace('{', ' ');
        l_sql = l_sql.replace('}', ' ');
        l_sql = l_sql.replace(';', ' ');
        l_sql = (this.isFunction ? "?" : "") + l_sql.substring(index + 4);
        l_sql = this.connection.haveMinimumServerVersion("7.3") ? "select * from " + l_sql + " as " + RESULT_ALIAS + ";" : "select " + l_sql + " as " + RESULT_ALIAS + ";";
        return l_sql;
    }

    protected void checkIndex(int parameterIndex, int type1, int type2, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type1 != this.testReturn && type2 != this.testReturn) {
            throw new PSQLException("postgresql.call.wrongget", PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH, new Object[]{"java.sql.Types=" + this.testReturn, getName, "java.sql.Types=" + type1});
        }
    }

    protected void checkIndex(int parameterIndex, int type, String getName) throws SQLException {
        this.checkIndex(parameterIndex);
        if (type != this.testReturn) {
            throw new PSQLException("postgresql.call.wrongget", PSQLState.MOST_SPECIFIC_TYPE_DOES_NOT_MATCH, new Object[]{"java.sql.Types=" + this.testReturn, getName, "java.sql.Types=" + type});
        }
    }

    private void checkIndex(int parameterIndex) throws SQLException {
        if (!this.isFunction) {
            throw new PSQLException("postgresql.call.noreturntype", PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        if (parameterIndex != 1) {
            throw new PSQLException("postgresql.call.noinout", PSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
    }

    public void setUseServerPrepare(boolean flag) throws SQLException {
        if (this.connection.haveMinimumServerVersion("7.3")) {
            if (this.m_useServerPrepare != flag) {
                this.deallocateQuery();
            }
            this.m_useServerPrepare = flag;
        }
    }

    public boolean isUseServerPrepare() {
        return this.m_useServerPrepare;
    }

    private Date dateFromString(String s2) throws SQLException {
        int timezone = 0;
        long millis = 0L;
        long localoffset = 0L;
        int timezoneLocation = s2.indexOf(43) == -1 ? s2.lastIndexOf("-") : s2.indexOf(43);
        try {
            timezone = timezoneLocation > 7 ? timezoneLocation : s2.length();
            millis = Date.valueOf(s2.substring(0, timezone)).getTime();
        }
        catch (Exception e2) {
            throw new PSQLException("postgresql.format.baddate", PSQLState.BAD_DATETIME_FORMAT, s2, "yyyy-MM-dd[-tz]");
        }
        timezone = 0;
        if (timezoneLocation > 7 && timezoneLocation + 3 == s2.length()) {
            timezone = Integer.parseInt(s2.substring(timezoneLocation + 1, s2.length()));
            localoffset = Calendar.getInstance().getTimeZone().getRawOffset();
            if (Calendar.getInstance().getTimeZone().inDaylightTime(new Date(millis))) {
                localoffset += 3600000L;
            }
            if (s2.charAt(timezoneLocation) == '+') {
                timezone *= -1;
            }
        }
        millis = millis + (long)(timezone * 60 * 60 * 1000) + localoffset;
        return new Date(millis);
    }

    private Time timeFromString(String s2) throws SQLException {
        int timezone = 0;
        long millis = 0L;
        long localoffset = 0L;
        int timezoneLocation = s2.indexOf(43) == -1 ? s2.lastIndexOf("-") : s2.indexOf(43);
        try {
            timezone = timezoneLocation == -1 ? s2.length() : timezoneLocation;
            millis = Time.valueOf(s2.substring(0, timezone)).getTime();
        }
        catch (Exception e2) {
            throw new PSQLException("postgresql.format.badtime", PSQLState.BAD_DATETIME_FORMAT, s2, "HH:mm:ss[-tz]");
        }
        timezone = 0;
        if (timezoneLocation != -1 && timezoneLocation + 3 == s2.length()) {
            timezone = Integer.parseInt(s2.substring(timezoneLocation + 1, s2.length()));
            localoffset = Calendar.getInstance().getTimeZone().getRawOffset();
            if (Calendar.getInstance().getTimeZone().inDaylightTime(new Date(millis))) {
                localoffset += 3600000L;
            }
            if (s2.charAt(timezoneLocation) == '+') {
                timezone *= -1;
            }
        }
        millis = millis + (long)(timezone * 60 * 60 * 1000) + localoffset;
        return new Time(millis);
    }

    private Timestamp timestampFromString(String s2) throws SQLException {
        int timezone = 0;
        long millis = 0L;
        long localoffset = 0L;
        int nanosVal = 0;
        int timezoneLocation = s2.indexOf(43) == -1 ? s2.lastIndexOf("-") : s2.indexOf(43);
        int nanospos = s2.indexOf(".");
        try {
            timezone = nanospos != -1 ? nanospos : (timezoneLocation > 8 ? timezoneLocation : s2.length());
            millis = Timestamp.valueOf(s2.substring(0, timezone)).getTime();
        }
        catch (Exception e2) {
            throw new PSQLException("postgresql.format.badtimestamp", PSQLState.BAD_DATETIME_FORMAT, s2, "yyyy-MM-dd HH:mm:ss[.xxxxxx][-tz]");
        }
        timezone = 0;
        if (nanospos != -1) {
            int tmploc = timezoneLocation > 8 ? timezoneLocation : s2.length();
            nanosVal = Integer.parseInt(s2.substring(nanospos + 1, tmploc));
            int diff = 8 - (tmploc - 1 - (nanospos + 1));
            for (int i2 = 0; i2 < diff; ++i2) {
                nanosVal *= 10;
            }
        }
        if (timezoneLocation > 8 && timezoneLocation + 3 == s2.length()) {
            timezone = Integer.parseInt(s2.substring(timezoneLocation + 1, s2.length()));
            localoffset = Calendar.getInstance().getTimeZone().getRawOffset();
            if (Calendar.getInstance().getTimeZone().inDaylightTime(new Date(millis))) {
                localoffset += 3600000L;
            }
            if (s2.charAt(timezoneLocation) == '+') {
                timezone *= -1;
            }
        }
        millis = millis + (long)(timezone * 60 * 60 * 1000) + localoffset;
        Timestamp tmpts = new Timestamp(millis);
        tmpts.setNanos(nanosVal);
        return tmpts;
    }
}

