/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.jdbc1.AbstractJdbc1Statement;
import org.postgresql.jdbc2.AbstractJdbc2Connection;
import org.postgresql.jdbc2.PBatchUpdateException;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc2Statement
extends AbstractJdbc1Statement {
    protected Vector batch = null;
    protected int resultsettype;
    protected int concurrency;

    public AbstractJdbc2Statement(AbstractJdbc2Connection c2) {
        super(c2);
        this.resultsettype = 1004;
        this.concurrency = 1007;
    }

    public AbstractJdbc2Statement(AbstractJdbc2Connection connection, String sql) throws SQLException {
        super(connection, sql);
    }

    public boolean execute() throws SQLException {
        boolean l_return = super.execute();
        this.result.setStatement(this);
        return l_return;
    }

    public void addBatch(String p_sql) throws SQLException {
        if (this.batch == null) {
            this.batch = new Vector();
        }
        Object[] l_statement = new Object[]{new String[]{p_sql}, new Object[0], new String[0]};
        this.batch.addElement(l_statement);
    }

    public void clearBatch() throws SQLException {
        this.batch = null;
    }

    public int[] executeBatch() throws SQLException {
        if (this.batch == null) {
            this.batch = new Vector();
        }
        int size = this.batch.size();
        int[] result = new int[size];
        int i2 = 0;
        try {
            String[] l_origSqlFragments = this.m_sqlFragments;
            Object[] l_origBinds = this.m_binds;
            String[] l_origBindTypes = this.m_bindTypes;
            for (i2 = 0; i2 < size; ++i2) {
                Object[] l_statement = (Object[])this.batch.elementAt(i2);
                this.m_sqlFragments = (String[])l_statement[0];
                this.m_binds = (Object[])l_statement[1];
                this.m_bindTypes = (String[])l_statement[2];
                result[i2] = this.executeUpdate();
            }
            this.m_sqlFragments = l_origSqlFragments;
            this.m_binds = l_origBinds;
            this.m_bindTypes = l_origBindTypes;
        }
        catch (SQLException e2) {
            int[] resultSucceeded = new int[i2];
            System.arraycopy(result, 0, resultSucceeded, 0, i2);
            PBatchUpdateException updex = new PBatchUpdateException("postgresql.stat.batch.error", new Integer(i2), this.m_sqlFragments[0], resultSucceeded);
            updex.setNextException(e2);
            throw updex;
        }
        finally {
            this.batch.removeAllElements();
        }
        return result;
    }

    public void cancel() throws SQLException {
        this.connection.cancelQuery();
    }

    public Connection getConnection() throws SQLException {
        return (Connection)((Object)this.connection);
    }

    public int getFetchDirection() throws SQLException {
        throw new PSQLException("postgresql.psqlnotimp", PSQLState.NOT_IMPLEMENTED);
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.concurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.resultsettype;
    }

    public void setFetchDirection(int direction) throws SQLException {
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new PSQLException("postgresql.input.fetch.gt0");
        }
        this.fetchSize = rows;
    }

    public void setResultSetConcurrency(int value) throws SQLException {
        this.concurrency = value;
    }

    public void setResultSetType(int value) throws SQLException {
        this.resultsettype = value;
    }

    public void addBatch() throws SQLException {
        if (this.batch == null) {
            this.batch = new Vector();
        }
        String[] l_newSqlFragments = null;
        if (this.m_sqlFragments != null) {
            l_newSqlFragments = new String[this.m_sqlFragments.length];
            System.arraycopy(this.m_sqlFragments, 0, l_newSqlFragments, 0, this.m_sqlFragments.length);
        }
        Object[] l_newBinds = new Object[this.m_binds.length];
        System.arraycopy(this.m_binds, 0, l_newBinds, 0, this.m_binds.length);
        String[] l_newBindTypes = new String[this.m_bindTypes.length];
        System.arraycopy(this.m_bindTypes, 0, l_newBindTypes, 0, this.m_bindTypes.length);
        Object[] l_statement = new Object[]{l_newSqlFragments, l_newBinds, l_newBindTypes};
        this.batch.addElement(l_statement);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet rs = this.getResultSet();
        if (rs != null) {
            return rs.getMetaData();
        }
        return null;
    }

    public void setArray(int i2, Array x2) throws SQLException {
        this.setString(i2, x2.toString());
    }

    public void setBlob(int i2, Blob x2) throws SQLException {
        InputStream l_inStream = x2.getBinaryStream();
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        int oid = lom.create();
        LargeObject lob = lom.open(oid);
        OutputStream los = lob.getOutputStream();
        byte[] buf = new byte[4096];
        try {
            int bytesRemaining = (int)x2.length();
            int numRead = l_inStream.read(buf, 0, Math.min(buf.length, bytesRemaining));
            while (numRead != -1 && bytesRemaining > 0) {
                bytesRemaining -= numRead;
                if (numRead == buf.length) {
                    los.write(buf);
                } else {
                    los.write(buf, 0, numRead);
                }
                numRead = l_inStream.read(buf, 0, Math.min(buf.length, bytesRemaining));
            }
        }
        catch (IOException se) {
            throw new PSQLException("postgresql.unusual", PSQLState.UNEXPECTED_ERROR, (Object)se);
        }
        finally {
            try {
                los.close();
                l_inStream.close();
            }
            catch (Exception e2) {}
        }
        this.setInt(i2, oid);
    }

    public void setCharacterStream(int i2, Reader x2, int length) throws SQLException {
        if (this.connection.haveMinimumCompatibleVersion("7.2")) {
            int l_charsRead;
            char[] l_chars = new char[length];
            try {
                l_charsRead = x2.read(l_chars, 0, length);
            }
            catch (IOException l_ioe) {
                throw new PSQLException("postgresql.unusual", PSQLState.UNEXPECTED_ERROR, (Object)l_ioe);
            }
            this.setString(i2, new String(l_chars, 0, l_charsRead));
        } else {
            LargeObjectManager lom = this.connection.getLargeObjectAPI();
            int oid = lom.create();
            LargeObject lob = lom.open(oid);
            OutputStream los = lob.getOutputStream();
            try {
                int c2 = x2.read();
                for (int p2 = 0; c2 > -1 && p2 < length; ++p2) {
                    los.write(c2);
                    c2 = x2.read();
                }
                los.close();
            }
            catch (IOException se) {
                throw new PSQLException("postgresql.unusual", PSQLState.UNEXPECTED_ERROR, (Object)se);
            }
            this.setInt(i2, oid);
        }
    }

    public void setClob(int i2, Clob x2) throws SQLException {
        InputStream l_inStream = x2.getAsciiStream();
        int l_length = (int)x2.length();
        LargeObjectManager lom = this.connection.getLargeObjectAPI();
        int oid = lom.create();
        LargeObject lob = lom.open(oid);
        OutputStream los = lob.getOutputStream();
        try {
            int c2 = l_inStream.read();
            for (int p2 = 0; c2 > -1 && p2 < l_length; ++p2) {
                los.write(c2);
                c2 = l_inStream.read();
            }
            los.close();
        }
        catch (IOException se) {
            throw new PSQLException("postgresql.unusual", PSQLState.UNEXPECTED_ERROR, (Object)se);
        }
        this.setInt(i2, oid);
    }

    public void setNull(int i2, int t2, String s2) throws SQLException {
        this.setNull(i2, t2);
    }

    public void setRef(int i2, Ref x2) throws SQLException {
        throw Driver.notImplemented();
    }

    public void setDate(int i2, Date d2, Calendar cal) throws SQLException {
        if (cal == null) {
            this.setDate(i2, d2);
        } else {
            cal.setTime(d2);
            this.setDate(i2, new Date(cal.getTime().getTime()));
        }
    }

    public void setTime(int i2, Time t2, Calendar cal) throws SQLException {
        if (cal == null) {
            this.setTime(i2, t2);
        } else {
            cal.setTime(t2);
            this.setTime(i2, new Time(cal.getTime().getTime()));
        }
    }

    public void setTimestamp(int i2, Timestamp t2, Calendar cal) throws SQLException {
        if (cal == null) {
            this.setTimestamp(i2, t2);
        } else {
            cal.setTime(t2);
            this.setTimestamp(i2, new Timestamp(cal.getTime().getTime()));
        }
    }

    public Array getArray(int i2) throws SQLException {
        throw Driver.notImplemented();
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkIndex(parameterIndex, 2, "BigDecimal");
        return (BigDecimal)this.callResult;
    }

    public Blob getBlob(int i2) throws SQLException {
        throw Driver.notImplemented();
    }

    public Clob getClob(int i2) throws SQLException {
        throw Driver.notImplemented();
    }

    public Object getObject(int i2, Map map) throws SQLException {
        throw Driver.notImplemented();
    }

    public Ref getRef(int i2) throws SQLException {
        throw Driver.notImplemented();
    }

    public Date getDate(int i2, Calendar cal) throws SQLException {
        throw Driver.notImplemented();
    }

    public Time getTime(int i2, Calendar cal) throws SQLException {
        throw Driver.notImplemented();
    }

    public Timestamp getTimestamp(int i2, Calendar cal) throws SQLException {
        throw Driver.notImplemented();
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw Driver.notImplemented();
    }

    protected String[] getSqlFragments() {
        return this.m_sqlFragments;
    }
}

