/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.BaseResultSet;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Field;
import org.postgresql.jdbc2.AbstractJdbc2ResultSet;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Array
implements java.sql.Array {
    private BaseConnection conn = null;
    private Field field = null;
    private BaseResultSet rs;
    private int idx = 0;
    private String rawString = null;

    public Array(BaseConnection conn, int idx, Field field, BaseResultSet rs) throws SQLException {
        this.conn = conn;
        this.field = field;
        this.rs = rs;
        this.idx = idx;
        this.rawString = rs.getFixedString(idx);
    }

    public Object getArray() throws SQLException {
        return this.getArray(1L, 0, (Map)null);
    }

    public Object getArray(long index, int count) throws SQLException {
        return this.getArray(index, count, (Map)null);
    }

    public Object getArray(Map map) throws SQLException {
        return this.getArray(1L, 0, map);
    }

    public Object getArray(long index, int count, Map map) throws SQLException {
        if (map != null) {
            throw Driver.notImplemented();
        }
        if (index < 1L) {
            throw new PSQLException("postgresql.arr.range", PSQLState.DATA_ERROR);
        }
        Object[] retVal = null;
        ArrayList<String> array = new ArrayList<String>();
        if (this.rawString != null && !this.rawString.equals("{}")) {
            char[] chars = this.rawString.toCharArray();
            StringBuffer sbuf = new StringBuffer();
            boolean foundOpen = false;
            boolean insideString = false;
            for (int i2 = 0; i2 < chars.length; ++i2) {
                if (chars[i2] == '\\') {
                    ++i2;
                } else {
                    if (!insideString && chars[i2] == '{') {
                        if (foundOpen) {
                            throw Driver.notImplemented();
                        }
                        foundOpen = true;
                        continue;
                    }
                    if (chars[i2] == '\"') {
                        insideString = !insideString;
                        continue;
                    }
                    if (!insideString && (chars[i2] == ',' || chars[i2] == '}') || i2 == chars.length - 1) {
                        if (chars[i2] != '\"' && chars[i2] != '}' && chars[i2] != ',') {
                            sbuf.append(chars[i2]);
                        }
                        array.add(sbuf.toString());
                        sbuf = new StringBuffer();
                        continue;
                    }
                }
                sbuf.append(chars[i2]);
            }
        }
        String[] arrayContents = array.toArray(new String[array.size()]);
        if (count == 0) {
            count = arrayContents.length;
        }
        if (--index + (long)count > (long)arrayContents.length) {
            throw new PSQLException("postgresql.arr.range", PSQLState.DATA_ERROR);
        }
        int i3 = 0;
        switch (this.getBaseType()) {
            case -7: {
                retVal = new boolean[count];
                while (count > 0) {
                    retVal[i3++] = AbstractJdbc2ResultSet.toBoolean(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 4: 
            case 5: {
                retVal = new int[count];
                while (count > 0) {
                    ((int[])retVal)[i3++] = AbstractJdbc2ResultSet.toInt(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case -5: {
                retVal = new long[count];
                while (count > 0) {
                    ((long[])retVal)[i3++] = AbstractJdbc2ResultSet.toLong(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 2: {
                retVal = new BigDecimal[count];
                while (count > 0) {
                    ((BigDecimal[])retVal)[i3++] = AbstractJdbc2ResultSet.toBigDecimal(arrayContents[(int)index++], -1);
                    --count;
                }
                break;
            }
            case 7: {
                retVal = new float[count];
                while (count > 0) {
                    ((float[])retVal)[i3++] = AbstractJdbc2ResultSet.toFloat(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 8: {
                retVal = new double[count];
                while (count > 0) {
                    ((double[])retVal)[i3++] = AbstractJdbc2ResultSet.toDouble(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 1: 
            case 12: {
                retVal = new String[count];
                while (count > 0) {
                    ((String[])retVal)[i3++] = arrayContents[(int)index++];
                    --count;
                }
                break;
            }
            case 91: {
                retVal = new Date[count];
                while (count > 0) {
                    ((Date[])retVal)[i3++] = AbstractJdbc2ResultSet.toDate(arrayContents[(int)index++]);
                    --count;
                }
                break;
            }
            case 92: {
                retVal = new Time[count];
                while (count > 0) {
                    ((Time[])retVal)[i3++] = AbstractJdbc2ResultSet.toTime(arrayContents[(int)index++], this.rs, this.getBaseTypeName());
                    --count;
                }
                break;
            }
            case 93: {
                retVal = new Timestamp[count];
                while (count > 0) {
                    ((Timestamp[])retVal)[i3++] = AbstractJdbc2ResultSet.toTimestamp(arrayContents[(int)index++], this.rs, this.getBaseTypeName());
                    --count;
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        return retVal;
    }

    public int getBaseType() throws SQLException {
        return this.conn.getSQLType(this.getBaseTypeName());
    }

    public String getBaseTypeName() throws SQLException {
        String fType = this.field.getPGType();
        if (fType.charAt(0) == '_') {
            fType = fType.substring(1);
        }
        return fType;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(1L, 0, (Map)null);
    }

    public ResultSet getResultSet(long index, int count) throws SQLException {
        return this.getResultSet(index, count, (Map)null);
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        return this.getResultSet(1L, 0, map);
    }

    public ResultSet getResultSet(long index, int count, Map map) throws SQLException {
        Object array = this.getArray(index, count, map);
        Vector<byte[][]> rows = new Vector<byte[][]>();
        Field[] fields = new Field[2];
        fields[0] = new Field(this.conn, "INDEX", this.conn.getPGType("int2"), 2);
        switch (this.getBaseType()) {
            case -7: {
                boolean[] booleanArray = (boolean[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("bool"), 1);
                for (int i2 = 0; i2 < booleanArray.length; ++i2) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i2));
                    tuple[1] = this.conn.getEncoding().encode(booleanArray[i2] ? "YES" : "NO");
                    rows.addElement(tuple);
                }
            }
            case 5: {
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("int2"), 2);
            }
            case 4: {
                int[] intArray = (int[])array;
                if (fields[1] == null) {
                    fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("int4"), 4);
                }
                for (int i3 = 0; i3 < intArray.length; ++i3) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i3));
                    tuple[1] = this.conn.getEncoding().encode(Integer.toString(intArray[i3]));
                    rows.addElement(tuple);
                }
                break;
            }
            case -5: {
                long[] longArray = (long[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("int8"), 8);
                for (int i4 = 0; i4 < longArray.length; ++i4) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i4));
                    tuple[1] = this.conn.getEncoding().encode(Long.toString(longArray[i4]));
                    rows.addElement(tuple);
                }
                break;
            }
            case 2: {
                BigDecimal[] bdArray = (BigDecimal[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("numeric"), -1);
                for (int i5 = 0; i5 < bdArray.length; ++i5) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i5));
                    tuple[1] = this.conn.getEncoding().encode(bdArray[i5].toString());
                    rows.addElement(tuple);
                }
                break;
            }
            case 7: {
                float[] floatArray = (float[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("float4"), 4);
                for (int i6 = 0; i6 < floatArray.length; ++i6) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i6));
                    tuple[1] = this.conn.getEncoding().encode(Float.toString(floatArray[i6]));
                    rows.addElement(tuple);
                }
                break;
            }
            case 8: {
                double[] doubleArray = (double[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("float8"), 8);
                for (int i7 = 0; i7 < doubleArray.length; ++i7) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i7));
                    tuple[1] = this.conn.getEncoding().encode(Double.toString(doubleArray[i7]));
                    rows.addElement(tuple);
                }
                break;
            }
            case 1: {
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("char"), 1);
            }
            case 12: {
                String[] strArray = (String[])array;
                if (fields[1] == null) {
                    fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("varchar"), -1);
                }
                for (int i8 = 0; i8 < strArray.length; ++i8) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i8));
                    tuple[1] = this.conn.getEncoding().encode(strArray[i8]);
                    rows.addElement(tuple);
                }
                break;
            }
            case 91: {
                Date[] dateArray = (Date[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("date"), 4);
                for (int i9 = 0; i9 < dateArray.length; ++i9) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i9));
                    tuple[1] = this.conn.getEncoding().encode(dateArray[i9].toString());
                    rows.addElement(tuple);
                }
                break;
            }
            case 92: {
                Time[] timeArray = (Time[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("time"), 8);
                for (int i10 = 0; i10 < timeArray.length; ++i10) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i10));
                    tuple[1] = this.conn.getEncoding().encode(timeArray[i10].toString());
                    rows.addElement(tuple);
                }
                break;
            }
            case 93: {
                Timestamp[] timestampArray = (Timestamp[])array;
                fields[1] = new Field(this.conn, "VALUE", this.conn.getPGType("timestamp"), 8);
                for (int i11 = 0; i11 < timestampArray.length; ++i11) {
                    byte[][] tuple = new byte[2][0];
                    tuple[0] = this.conn.getEncoding().encode(Integer.toString((int)index + i11));
                    tuple[1] = this.conn.getEncoding().encode(timestampArray[i11].toString());
                    rows.addElement(tuple);
                }
                break;
            }
            default: {
                throw Driver.notImplemented();
            }
        }
        BaseStatement stat = (BaseStatement)((Object)this.conn.createStatement());
        return (ResultSet)((Object)stat.createResultSet(fields, rows, "OK", 1, 0L));
    }

    public String toString() {
        return this.rawString;
    }
}

