/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2.optional;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.postgresql.jdbc2.optional.BaseDataSource;
import org.postgresql.jdbc2.optional.ConnectionPool;
import org.postgresql.jdbc2.optional.PoolingDataSource;
import org.postgresql.jdbc2.optional.SimpleDataSource;

public class PGObjectFactory
implements ObjectFactory {
    static /* synthetic */ Class class$org$postgresql$jdbc2$optional$SimpleDataSource;
    static /* synthetic */ Class class$org$postgresql$jdbc2$optional$ConnectionPool;
    static /* synthetic */ Class class$org$postgresql$jdbc2$optional$PoolingDataSource;

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Reference ref = (Reference)obj;
        if (ref.getClassName().equals((class$org$postgresql$jdbc2$optional$SimpleDataSource == null ? (class$org$postgresql$jdbc2$optional$SimpleDataSource = PGObjectFactory.class$("org.postgresql.jdbc2.optional.SimpleDataSource")) : class$org$postgresql$jdbc2$optional$SimpleDataSource).getName())) {
            return this.loadSimpleDataSource(ref);
        }
        if (ref.getClassName().equals((class$org$postgresql$jdbc2$optional$ConnectionPool == null ? (class$org$postgresql$jdbc2$optional$ConnectionPool = PGObjectFactory.class$("org.postgresql.jdbc2.optional.ConnectionPool")) : class$org$postgresql$jdbc2$optional$ConnectionPool).getName())) {
            return this.loadConnectionPool(ref);
        }
        if (ref.getClassName().equals((class$org$postgresql$jdbc2$optional$PoolingDataSource == null ? (class$org$postgresql$jdbc2$optional$PoolingDataSource = PGObjectFactory.class$("org.postgresql.jdbc2.optional.PoolingDataSource")) : class$org$postgresql$jdbc2$optional$PoolingDataSource).getName())) {
            return this.loadPoolingDataSource(ref);
        }
        return null;
    }

    private Object loadPoolingDataSource(Reference ref) {
        String max;
        String name = this.getProperty(ref, "dataSourceName");
        PoolingDataSource pds = PoolingDataSource.getDataSource(name);
        if (pds != null) {
            return pds;
        }
        pds = new PoolingDataSource();
        pds.setDataSourceName(name);
        this.loadBaseDataSource(pds, ref);
        String min = this.getProperty(ref, "initialConnections");
        if (min != null) {
            pds.setInitialConnections(Integer.parseInt(min));
        }
        if ((max = this.getProperty(ref, "maxConnections")) != null) {
            pds.setMaxConnections(Integer.parseInt(max));
        }
        return pds;
    }

    private Object loadSimpleDataSource(Reference ref) {
        SimpleDataSource ds = new SimpleDataSource();
        return this.loadBaseDataSource(ds, ref);
    }

    private Object loadConnectionPool(Reference ref) {
        ConnectionPool cp = new ConnectionPool();
        return this.loadBaseDataSource(cp, ref);
    }

    protected Object loadBaseDataSource(BaseDataSource ds, Reference ref) {
        ds.setDatabaseName(this.getProperty(ref, "databaseName"));
        ds.setPassword(this.getProperty(ref, "password"));
        String port = this.getProperty(ref, "portNumber");
        if (port != null) {
            ds.setPortNumber(Integer.parseInt(port));
        }
        ds.setServerName(this.getProperty(ref, "serverName"));
        ds.setUser(this.getProperty(ref, "user"));
        return ds;
    }

    protected String getProperty(Reference ref, String s2) {
        RefAddr addr = ref.get(s2);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

